function PortCheck(I,low){
	d =parseInt(I.value, 10);
	if ( !( d<65536 && d>=low) ) {
		alert('Port value out of range ['+low+' - 65535]');
		I.value = I.defaultValue;
	}
}

function PortCheckZero(I,low){
	d =parseInt(I.value, 10);
	if ( !( d<65536 && d>=low) ) {
                if (d != 0) { 
		  alert('Port value out of range ['+low+' - 65535] or 0 to disable');
		  I.value = I.defaultValue;
                }
	}
}

function intCheck(I,low,max){
	d =parseInt(I.value, 10);
	if ( !( d<=max && d>=low) ) {
		alert('Integer value out of range ['+low+' - '+max+']');
		I.value = I.defaultValue;
	}
}

/* 
 * use IPCheck for single value boxes
 * use IPAddrCheck for whole x.x.x.x IPV4 checks.
 */
function IPCheck(I){
	d =parseInt(I.value, 10);
	if ( !(d<256 && d>=0) ) {
		alert('IP value out of range [0 - 255]');
		I.value = I.defaultValue;
	}
}

function IPAddrCheck(I,allow_blank){
	if (allow_blank && I.value=="") return;
	var d,i;
	var iparr=I.value.split('.');
	for (i=0;i<4;++i) {
		d=parseInt(iparr[i], 10);
		if ( !(d<256 && d>=0) ) {
			alert('IP value out of range [0 - 255]');
               		I.value = I.defaultValue;
			return;
		}
	}
}

function netMaskCheck(I,last){
	d =parseInt(I.value, 10);
	if( !(d==0 || d==128 || d==192 || d==224 || d==240 || d==248 || d==252 || d==254 || (!last && d==255) )) {
		alert('Incorrect netmask value');
		I.value = I.defaultValue;
	}
}

function NetmaskCheck(I){
	var iparr=I.value.split('.');
	var last;
	for (i=0;i<4;++i) {
		d=parseInt(iparr[i], 10);
		last = (i==3);
		if( !(d==0 || d==128 || d==192 || d==224 || d==240 || d==248 || d==252 || d==254 || (!last && d==255)) ) {
			alert('Incorrect netmask value');
			I.value = I.defaultValue;
			return;
		}
	}
}

function volumeCheck(I) {
	d =parseInt(I.value, 10);
	if (d<0 || d>100) {
		alert('Volume setting out of range [0 - 100]');
		I.value=I.defaultValue;
	}
}

/* set form element visibility via CSS */
function set_display(id,display)
{
	var c=parent.frames['cfg'].document;
	obj=c.getElementById(id);
	if (obj) obj.style.display=display;
}


/* switch static/DHCP network settings */
function select_network_settings() {
	var f=document.forms["settings"];
	var is_static=f.elements["network.eth0.proto"].selectedIndex;		/* 0=DHCP, 1=static */

	set_display('ip_addr',(is_static?"":"none"));
	set_display('netmask',(is_static?"":"none"));
	set_display('gateway',(is_static?"":"none"));
	set_display('dns1',(is_static?"":"none"));
	set_display('dns2',(is_static?"":"none"));
	set_display('dhcp_name',(is_static?"none":""));
}

