/**
 * WIFI STUFF
 */


/**
 * Obtain a wifi status using ajax. NOTE: this method is synchronous.
 */
const WIFI_SSIDS_ENDPOINT = "/cgi-bin/wifiSsids.cgi";
let _wifiLastSsidsJson = null;
function updateWifiSsids() {
    commonToolsReadJsonFile(WIFI_SSIDS_ENDPOINT + "?" + (new Date()).getTime(), false, function (content) {
        if (content) {
            try {
                const ssidsJson = JSON.parse(content);
                // Only do a status render if if fist time or data is different
                if (ssidsJson) {
                    _wifiLastSsidsJson = ssidsJson;
                }
            } catch (e) {
                // console.log("ssidsJson PARSE ERROR");
            }
        } else {
            // console.log("ssidsJson has no content");
        }
    });
}


function getWifiStateLabel() {
    return getWifiState();
}


const updateWifiSsidsTimer = setInterval(updateWifiSsids, 5000);
updateWifiSsids();


function getWifiSsids() {
    return _wifiLastSsidsJson ? _wifiLastSsidsJson.networks : [];
}


function generateWirelessStrength(intensity) {
    let value = "&lrtri;";
    const meter = intensity / 25;
    for (let i = 0; i < meter; i++) {
        value += '&VerticalSeparator;';
    }
    return value;
}


// Endpoint to obtain the configuration values from UCI in JSON format
const WIFI_STATUS_ENDPOINT = "/cgi-bin/wifiStatus.cgi";
let _wifiLastStatusJson = null;


/**
 * Obtain a wifi status using ajax. NOTE: this method is synchronous.
 */
function updateWifiStatus() {
    commonToolsReadJsonFile(WIFI_STATUS_ENDPOINT + "?" + (new Date()).getTime(), true, function (content) {
        if (content) {
            try {
                const statusJson = JSON.parse(content);
                // Only do a status render if if fist time or data is different
                if (statusJson) {
                    _wifiLastStatusJson = statusJson;
                }
            } catch (e) {
                // console.log("statusJson PARSE ERROR");
            }
        } else {
            // console.log("statusJson has no content");
        }
    });
}


function getWifiStatusValue(varName)    {
    if (varName === "ipAddress" || varName === "netMask")   {
        return _wifiLastStatusJson && _wifiLastStatusJson[varName];
    } else {
        return _wifiLastStatusJson && _wifiLastStatusJson.wifiStatus && _wifiLastStatusJson.wifiStatus[varName];
    }
}


function getWifiStatusValueSafe(varName)    {
    const value = getWifiStatusValue(varName);
    return value ? value : "n/a";
}


function getWifiState() {
    return getWifiStatusValue("state");
}


function getWifiStateStyle() {
    const state =  getWifiState();
    if (state) {
        switch (state)  {
            case "wirelessStatusGreen":
                return "";
            case "Connecting":
                return "wirelessStatusYellow";
        }
    }
    return "wirelessStatusGray";
}


function refreshWifiStatus()    {

    const wifiConnectionState = getWifiStatusValueSafe("state");

    if (!wifiConnectionState || wifiConnectionState==="n/a")    {
        commonToolsHideElemId("row-status-wifi-connection-header");
        commonToolsHideElemId("row-status-wifi-connection");
    } else {
        commonToolsShowElemId("row-status-wifi-connection-header");
        commonToolsShowElemId("row-status-wifi-connection");

        let valueWifiStateElem = document.getElementById('value-wifi-state');
        if (valueWifiStateElem) {
            valueWifiStateElem.innerText = getWifiStatusValueSafe("state");
        }
        let valueWifiMacAddressElem = document.getElementById('value-wifi-mac_address');
        if (valueWifiMacAddressElem) {
            valueWifiMacAddressElem.innerText = getWifiStatusValueSafe("mac_address");
        }
        let valueWifiSsidElem = document.getElementById('value-wifi-ssid');
        if (valueWifiSsidElem) {
            valueWifiSsidElem.innerText = getWifiStatusValueSafe("ssid");
        }
        let valueWifiRssiElem = document.getElementById('value-wifi-rssi');
        if (valueWifiRssiElem) {
            valueWifiRssiElem.innerText = getWifiStatusValueSafe("rssi");
        }
        let valueWifiIp_addressElem = document.getElementById('value-wifi-ip_address');
        if (valueWifiIp_addressElem) {
            valueWifiIp_addressElem.innerText = getWifiStatusValueSafe("ipAddress");
        }
        let valueWifiNet_maskElem = document.getElementById('value-wifi-net_mask');
        if (valueWifiNet_maskElem) {
            valueWifiNet_maskElem.innerText = getWifiStatusValueSafe("netMask");
        }

        let valueWifiStatusDotElem = document.getElementById('value-wireless-status-dot');
        if (valueWifiStatusDotElem) {
            valueWifiStatusDotElem.title = "";
            valueWifiStatusDotElem.setAttribute("class", "wirelessStatus");
            const wifiState = getWifiStatusValue("state");
            if (wifiState) {
                valueWifiStatusDotElem.title = wifiState;
                switch (wifiState) {
                    case "Connected":
                        valueWifiStatusDotElem.classList.add("wirelessStatusGreen");
                        break;
                    case "Connecting":
                        valueWifiStatusDotElem.classList.add("wirelessStatusYellow");
                        break;
                    case "Error":
                        valueWifiStatusDotElem.classList.add("wirelessStatusRed");
                        break;
                    default:
                        valueWifiStatusDotElem.classList.add("wirelessStatusGray");
                }
            }
        }
    }
}

const refreshWifiStatusTimer = setInterval(refreshWifiStatus, 2500);


/**
 * Render wireless SSID
 *
 * @param current
 * @returns {string} options rendered
 */
function renderWirelessSsidOptions(current) {
    const tdElem = document.getElementById('wireless_select_ssid');
    const ssids = getWifiSsids();

    let options = '';
    options += '<option value="">(disabled)</option>';
    if (ssids && ssids.length) {
        ssids.sort((a, b) => (a.rssi > b.rssi) ? -1 : 1);
        for (let i = 0; i < ssids.length; i++) {
            const ssid= ssids[i];
            options += '<option value="' + ssid.ssid + '"' + (current === ssid.ssid ? ' selected="selected"' : '') + '>' + generateWirelessStrength(ssid.rssi) + '&nbsp;&nbsp;&nbsp;' + ssid.ssid + '&nbsp;</option>';
        }
    }
    tdElem.innerHTML = '<select class="mediumText" id="select_ssid" name="network.wlan0.ssid" onchange="viewWirelessParameters(this.value)">' + options + '</select>';
}


const updateWifiStatusTimer = setInterval(updateWifiStatus, 2000);
updateWifiStatus();
