// Endpoint to obtain the mass storage devices info
const MASS_STORAGE_ENDPOINT = "/cgi-bin/getMountDevices.cgi";


/**
 * Build a SVG with a used percentage bar
 * @param percentage
 * @param widthPx
 * @param heightPx
 * @returns {SVGSVGElement}
 */
function buildUsedBarSvgElem(percentage, widthPx, heightPx) {
    const svgNS = "http://www.w3.org/2000/svg";
    const svgElem = document.createElementNS(svgNS, "svg");
    svgElem.setAttribute("width", "" + widthPx);
    svgElem.setAttribute("height", "" + heightPx);
    const rectAvailableElem = document.createElementNS(svgNS, "rect");
    rectAvailableElem.setAttributeNS(null, "width", "" + widthPx);
    rectAvailableElem.setAttributeNS(null, "height", "" + heightPx);
    rectAvailableElem.setAttributeNS(null, "style", "fill:rgb(0,200,0);");
    const rectAvailableTitleElem = document.createElementNS(svgNS, "title");
    rectAvailableTitleElem.textContent = "Available " + (100 - percentage) + "%";
    rectAvailableElem.appendChild(rectAvailableTitleElem);
    svgElem.appendChild(rectAvailableElem);
    const rectUsedElem = document.createElementNS(svgNS, "rect");
    rectUsedElem.setAttributeNS(null, "width", "" + (percentage * widthPx / 100));
    rectUsedElem.setAttributeNS(null, "height", "" + heightPx);
    rectUsedElem.setAttributeNS(null, "style", "fill:rgb(200,0,0);");
    const rectUsedTitleElem = document.createElementNS(svgNS, "title");
    rectUsedTitleElem.textContent = "Used " + percentage + "%";
    rectUsedElem.appendChild(rectUsedTitleElem);
    svgElem.appendChild(rectUsedElem);
    return svgElem;
}


// Load a application solution hook and run the onload function (app_network_onload)
function onload_status(version) {
    commonToolsDynamicallyLoadScript("/app/javascript/app_status.js?v=" + version, function () {
        if (typeof onloadAppStatusJs === "function") {
            onloadAppStatusJs();
        }
    });
}


/**
 * Render a Mass Storage Devices table on a given parent id
 * @param parentId
 */
function renderMassStorageDevicesTable(parentId) {
    const parentElem = document.getElementById(parentId);
    if (parentElem) {
        const sourceStatusTable = document.createElement("table");
        sourceStatusTable.setAttribute("cellspacing", "0");
        sourceStatusTable.setAttribute("cellpadding", "0");
        sourceStatusTable.setAttribute("style", "border-radius: 0px; margin-bottom: 8px; background-color: #EEEEEE;");
        // Table header
        commonToolsReadJsonFile(MASS_STORAGE_ENDPOINT, true, function (data) {
            if (data) {
                try {
                    const dataJson = JSON.parse(data);
                    const mountedDevices = dataJson.mountedDevices;
                    if (mountedDevices && mountedDevices.length > 0) {

                        // Table
                        const tableElem = document.createElement("table");
                        tableElem.setAttribute("cellspacing", "0");
                        tableElem.setAttribute("cellpadding", "0");
                        // tableElem.setAttribute("style", "border-radius: 0px; margin-bottom: 8px; background-color: #F4AAAA; text-align: center; width: 500px; padding: 8px;");
                        tableElem.id = parentId + "-table";
                        tableElem.setAttribute("class", parentId + "-table");

                        // Render table header
                        const rowHeaderElem = tableElem.insertRow(-1);

                        // Type
                        const deviceCellElem = rowHeaderElem.insertCell(-1);
                        deviceCellElem.innerText = "Type";

                        // Use %
                        const usePercCellElem = rowHeaderElem.insertCell(-1);
                        usePercCellElem.innerText = "Usage";

                        // Size
                        const sizeCellElem = rowHeaderElem.insertCell(-1);
                        sizeCellElem.innerText = "Size";

                        // Used
                        const usedCellElem = rowHeaderElem.insertCell(-1);
                        usedCellElem.innerText = "Used";

                        // Available
                        const availableCellElem = rowHeaderElem.insertCell(-1);
                        availableCellElem.innerText = "Avail.";

                        // File System
                        const fileSystemCellElem = rowHeaderElem.insertCell(-1);
                        fileSystemCellElem.innerText = "F. Sys";

                        // Status
                        const statusCellElem = rowHeaderElem.insertCell(-1);
                        statusCellElem.innerText = "Status";

                        for (let d = 0; d < mountedDevices.length; d++) {
                            // Render rows
                            const dataRowElem = tableElem.insertRow(-1);

                            // Type
                            const deviceCellElem = dataRowElem.insertCell(-1);
                            deviceCellElem.innerText = mountedDevices[d].type;
                            deviceCellElem.style.textAlign = "left";

                            // Use %
                            const usePercCellElem = dataRowElem.insertCell(-1);
                            usePercCellElem.appendChild(buildUsedBarSvgElem(mountedDevices[d].use.replace("%", ""), 80, 12));
                            usePercCellElem.style.width = "1%";
                            usePercCellElem.style.textAlign = "center";

                            // Size
                            const sizeCellElem = dataRowElem.insertCell(-1);
                            sizeCellElem.innerText = mountedDevices[d].size;
                            sizeCellElem.style.textAlign = "right";

                            // Used
                            const usedCellElem = dataRowElem.insertCell(-1);
                            usedCellElem.innerText = mountedDevices[d].used;
                            usedCellElem.style.textAlign = "right";

                            // Available
                            const availableCellElem = dataRowElem.insertCell(-1);
                            availableCellElem.innerText = mountedDevices[d].available;
                            availableCellElem.style.textAlign = "right";

                            // File System
                            const fileSystemCellElem = dataRowElem.insertCell(-1);
                            fileSystemCellElem.innerText = mountedDevices[d].fsType;
                            fileSystemCellElem.style.textAlign = "left";

                            // Status
                            const statusCellElem = dataRowElem.insertCell(-1);
                            statusCellElem.innerText = mountedDevices[d].mountAs === "rw" ? "read-write" : "read-only";
                            statusCellElem.style.textAlign = "left";

                        }
                        parentElem.appendChild(tableElem);
                    } else {
                        parentElem.innerText = "no mass storage devices detected"
                    }
                } catch (e) {
                    // console.log("dataJson PARSE ERROR");
                }
            } else {
                // console.log("dataJson has no content");
            }
        });
    }
}