const TemplatePrefix = "template-";

/**
 * Add to DOM a modal template.
 */
function modalTemplateInDom(templateId) {
    let modalTemplate = document.getElementById(templateId);
    if (!modalTemplate) {
        const modalCloseId = templateId + "-close";
        const modalTitleId = templateId + "-title";
        modalTemplate = document.createElement("div");
        modalTemplate.innerHTML = '<!-- Modal content -->\n' +
            '      <div class="modal-content">\n' +
            '        <div id=' + modalCloseId + ' class="modal-close"></div>' +
            '        <h3 id=' + modalTitleId + ' template="title"></h3>\n' +
            '        <div template="body">\n' +
            '        </div>\n' +
            '      </div>';

        modalTemplate.id = templateId;
        modalTemplate.setAttribute("class", "modal");
        modalTemplate.setAttribute("style", "display: none;");
        document.body.appendChild(modalTemplate);
        // console.log("Modal template added to DOM");
        return false;
    } else {
        // console.warn("Modal template already in DOM");
        return true;
    }
}

function openPopup(modalId) {
    templateId = TemplatePrefix + modalId;
    const modal = document.getElementById(templateId);
    modal.style.display = "block";
}

function closePopup(modalId) {
    templateId = TemplatePrefix + modalId;
    const modal = document.getElementById(templateId);
    modal.style.display = "none";
}

/**
 * Show the made modal
 */
function showPopup(modalId, isModal, disableEscapeKeyClose) {
    templateId = TemplatePrefix + modalId;

    openPopup(modalId);
    const modalCloseDiv = document.getElementById(templateId + "-close");
    modalCloseDiv.innerText="×";
    modalCloseDiv.onclick = function () {
        closePopup(modalId);
    };

    // When the user clicks anywhere outside of the modal, close it
    if (!isModal) {
        window.onclick = function (event) {
            const modal = document.getElementById(templateId);
            if (event.target === modal) {
                modal.style.display = "none";
            }
        };
    }

    if (!disableEscapeKeyClose) {
        function keyEscapeDown(e) {
            const keyCode = e.keyCode;
            if (keyCode === 27) {
                const modal = document.getElementById(templateId);
                modal.style.display = "none";
            }
        }

        document.addEventListener("keydown", keyEscapeDown, false);
    }

}

/**
 * Get a element with a specific attribute inside a element id
 * @param templateId
 * @param fragment
 * @returns {Element}
 */
function getFragmentElem(templateId, fragment) {
    let fragmentElem;
    if (fragment) {
        const elementsWithAttribute = document.getElementById(templateId);
        if (elementsWithAttribute) {
            const fragmentArray = elementsWithAttribute.querySelectorAll("[" + fragment + "]");
            if (fragmentArray.length > 0) {
                fragmentElem = fragmentArray[0];
            }
        } else {
            console.warn("Template \"%s\" not found", templateId);
        }
    } else {
        fragmentElem = document.getElementById(templateId);
    }
    return fragmentElem;
}

/**
 * Copy the content of a content template element to the template element with a specific attribute
 * @param templateId template element
 * @param contentId content element
 * @param templateAttributeName attribute identifier that will be copied
 */
function copyElementContent2Template(templateId, contentId, templateAttributeName) {
    let templateContainer = getFragmentElem(templateId, "template=" + templateAttributeName);
    // console.log("templateContainer - "+ templateId, templateContainer);
    if (templateContainer) {
        let content = getFragmentElem(contentId, "template=" + templateAttributeName);
        // console.log("content - " + contentId, content);
        if (content) {
            templateContainer.innerHTML = content.innerHTML;
        }
    }
}


/**
 * Build a modal, based in a template with the given content
 * @param templateId
 * @param contentId
 */
function buildModal(modalId) {
    templateId = TemplatePrefix + modalId;
    if (!modalTemplateInDom(templateId)) {
        copyElementContent2Template(templateId, modalId, "title");
        copyElementContent2Template(templateId, modalId, "body");
        document.getElementById(modalId).remove();
    }
}
