const is_firefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
const isIE = 0;

const delay = 1000;
let xmlhttp = false;
let empty_cnt;
let app_state = false;

function stopAppConfirm() {
    if (app_state) {
        if (confirm("Are you sure you want to stop the application?")) {
            sendSingleCommand('app_stop=1');
        }
    }
}

function reconnectConfirm() {
    if (confirm("Are you sure you want to reconnect the device to the Flexa registry?")) {
        sendSingleCommand('reconnect=1');
    }
}

// get best/appropriate xmlhttprequest object
if (isIE) {
    try {
        xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
} else {
    xmlhttp = false;
}
// now go with std (non IE) xmlhttp
if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
    try {
        xmlhttp = new XMLHttpRequest();
    } catch (e) {
        xmlhttp = false;
    }
}

function send_xmlhttp_request(url, funct) {
    xmlhttp.open("GET", url, true);
    if (!isIE)
        xmlhttp.overrideMimeType('text/plain');
    xmlhttp.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT");
    if (!funct) funct = function () {
    };
    xmlhttp.onreadystatechange = funct;
    xmlhttp.send(null);
}

function gotStatus(data) {
    /*
     * not found http error <?xml  ?
     */
    if (data.substr(0, 2) === "<?") return;

    if (data !== "") {
        processStatusData(data);
    } else {
        //did not get response, stop polling and report error
        // stop sending requests
        // send_xmlhttp_request("/cgi-bin/sip.cgi?get_status=1",0);
    }
    setTimeout("getStatus()", delay);
}

function getStatus() {
    if (xmlhttp) {
        function reply() {
            if (xmlhttp.readyState === 4) {
                gotStatus(xmlhttp.responseText);
            }
        }

        send_xmlhttp_request("/cgi-bin/command.cgi?get_player_status=1", reply);
    }
}

function startStatusPolling() {
    empty_cnt = 0;
    setTimeout("getStatus()", delay);
}

function processStatusData(statusData) {
    const state = statusData;
    try {
        const jsonObj = JSON.parse(statusData);
        if (jsonObj.app_state) {
            document.getElementById('player_state').style.color = "green";
            document.getElementById('player_state').innerHTML = "running";
        } else {
            document.getElementById('player_state').style.color = "red";
            document.getElementById('player_state').innerHTML = "not running";
        }
        app_state = jsonObj.app_state;
    } catch (e) {
        document.getElementById('player_state').innerHTML = "n/a";
    }
}

function processThreshold() {
    const slider = document.getElementById("threshold");
    const threshold = slider.value;
    sendSingleCommand('set_threshold=' + threshold)
}

function processCallId() {
    const field = document.getElementById("call_uri");
    const call_uri = field.value;
    sendSingleCommand('make_call=' + call_uri)
}

function uploadHandler(modalId) {
    buildModal(modalId);
    showPopup(modalId, false);
}

function checkFilename(el, button) {
    const fileName = document.getElementById(el.id);
    const supportedUploadExtensions = fileName.getAttribute("accept").split(",");
    const uploadButton = document.getElementById(button);

    isValidFile = false;
    if (fileName && !!fileName.value) {
        let fileExtension = fileName.value.substring(fileName.value.indexOf(".")).toLowerCase();
        isValidExtension = false;
        for (let i=0; i<supportedUploadExtensions.length; i++) {
            if (fileExtension.endsWith(supportedUploadExtensions[i])) {
                isValidExtension = true;
                break;
            }
        }
        if (!isValidExtension) {
            notify.notify({message:'Format not yet supported!', level:'warning'});
        } else {
            isValidFile = true;
        }
    }
    uploadButton.disabled = !isValidFile;
}


function submitChanges()    {
    document.getElementById('flexa-home-form').submit();
}
