
/**
 * USE deepEqual instead!
 * @param object1
 * @param object2
 * @param deep deep of analysis. Recursive protection.
 * @returns {boolean}
 */
function _deepEqualSafe(object1, object2, deep) {

    if (deep <= 0) {
        console.error("Comparing objects too deep. Please contact support (https://www.barix.com/support/).");
        return false;
    }

    const keys1 = Object.keys(object1);
    const keys2 = Object.keys(object2);

    if (keys1.length !== keys2.length) {
        return false;
    }

    for (const key of keys1) {
        const val1 = object1[key];
        const val2 = object2[key];
        const areObjects = isObject(val1) && isObject(val2);
        if (
            areObjects && !_deepEqualSafe(val1, val2, --deep) ||
            !areObjects && val1 !== val2
        ) {
            return false;
        }
    }

    return true;
}


/**
 * Deep comparison of a json object
 * @param object1
 * @param object2
 * @returns {boolean}
 */
function commonToolsDeepEqual(object1, object2) {
    return _deepEqualSafe(object1, object2, 50);
}


/* hide html table row */
function commonToolsHideElemId(id) {
    let elem = document.getElementById(id);
    if (elem) elem.style.display = "none";
}


/* show html table row
   Latest version of Firefox use "block" to show previously
   hidden table row when style.display='' is used in JS code
   This causes problems with select options drop down menus
   not being selectable with the mouse, so handle it
   it here differently here */
function commonToolsShowElemId(id) {
    let elem = document.getElementById(id);
    if (elem) {
        elem.style.display = "";
    }
}


/* Remove element from DOM */
function commonToolsRemoveElemId(id) {
    let elem = document.getElementById(id);
    if (elem) elem.remove();
}


/**
 *  Function to include HTMLs files.
 *  To include a HTML file, define in the place code like:
 *  <div include-html="content_to_include.html"></div>
 *
 *  You must to call this method on load document
 *
 */
function commonToolsIncludeHTML(callbackFunction) {
    let elemByTag, scanningElem, fileToInclude, xhttp;
    elemByTag = document.getElementsByTagName("*");
    for (let i = 0; i < elemByTag.length; i++) {
        scanningElem = elemByTag[i];
        fileToInclude = scanningElem.getAttribute("include-html");
        if (fileToInclude) {
            xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                if (this.readyState === 4) {
                    if (this.status === 200) {
                        scanningElem.innerHTML = this.responseText;

                        let scriptOnload = scanningElem.getAttribute("include-onload");
                        if (scriptOnload) {
                            try {
                                window[scriptOnload]();
                            } catch (error) {
                                console.error("Define and Use onloadAppSettingsJs() on include script instead to execute functions onLoad script.");
                                console.error("Not found \"include-onload\" script",scriptOnload, error);
                            }
                        }

                        scanningElem.removeAttribute("include-html");
                        scanningElem.setAttribute("www-data-source", fileToInclude);
                        commonToolsIncludeHTML(callbackFunction);
                        // console.log("Include \"" + fileToInclude + "\"");
                        commonToolsAddCollapsablePanelsHandlers();
                    }
                }
            };
            xhttp.open("GET", fileToInclude, true);
            xhttp.send();
            return;
        }
    }
    if (callbackFunction) {
        callbackFunction();
    }
}

/**
 * Load a javascript file dynamically
 * @param url
 * @param successCallback
 * @param failCallback
 */
function commonToolsDynamicallyLoadScript2(url, successCallback, failCallback) {
    let xhttp = new XMLHttpRequest();
    xhttp.onreadystatechange = function () {
        console.log("this.readyState", this.readyState, "this.status", this.status);
        if (this.readyState === 4)  {
            if (this.status === 200) {
                const head = document.head;
                // create a script DOM node
                const script = document.createElement("script");
                script.type = 'text/javascript';
                // set its src to the provided URL
                script.innerText = this.responseText;
                // Then bind the event to the callback function.
                // There are several events for cross browser compatibility.
                if (successCallback && typeof successCallback === "function") {
                    script.onreadystatechange = successCallback;
                    script.onload = successCallback;
                }
                // add it to the end of the head section of the page (could change 'head' to 'body' to add it to the end of the body section instead)
                head.appendChild(script);

                // if (successCallback && typeof successCallback === "function")   {
                //      successCallback();
                // }
            }
        } else  {
            if (failCallback && typeof failCallback === "function") {
                failCallback();
            }
        }
    };
    xhttp.open("GET", url, false);
    xhttp.send();
}

/**
 * Load a javascript file dynamically
 * @param url
 * @param successCallback
 * @param failCallback
 */
function commonToolsDynamicallyLoadScript(url, successCallback) {
    const head = document.head;
    // create a script DOM node
    const script = document.createElement("script");
    script.type = 'text/javascript';
    // set its src to the provided URL
    script.src = url;
    // Then bind the event to the callback function.
    // There are several events for cross browser compatibility.
    if (successCallback && typeof successCallback === "function") {
        script.onreadystatechange = successCallback;
        script.onload = successCallback;
    }
    // add it to the end of the head section of the page (could change 'head' to 'body' to add it to the end of the body section instead)
    head.appendChild(script);
}


/**
 * Get a file using ajax. NOTE: this method is synchronous.
 * @param url
 * @param asAsync
 * @param callback
 */
function commonToolsReadJsonFile(url, asAsync, callback) {
    const rawFileRequest = new XMLHttpRequest();
    rawFileRequest.overrideMimeType("application/json");
    rawFileRequest.open("GET", url, asAsync);
    rawFileRequest.onreadystatechange = function () {
        if (rawFileRequest.readyState === 4 && rawFileRequest.status === 200) {
            callback(rawFileRequest.responseText);
        }
    };
    rawFileRequest.send(null);
}


/**
 * Send a command to backend using GET request
 * @param command
 */
function sendSingleCommand_NEW(command) {
    const xhttp = new XMLHttpRequest();
    xhttp.open("GET", "/cgi-bin/command.cgi?" + command, true);
    xhttp.send();
}


/**
 * Deprecated...
 * @param cmd
 */
function sendSingleCommand(cmd) {
    const randomActNo = Math.floor(Math.random() * 1001);
    // use fake img to send data without reloading
    document.images["senddataimg"].src = "/cgi-bin/command.cgi?" + cmd + "&" + randomActNo;
}


/**
 * Send a http get request asynchronously
 * @param cgiName
 * @param params
 */
function commonToolsSendXMLHttpGetRequest(cgiName, params) {
    const xhttp = new XMLHttpRequest();
    xhttp.open("GET", cgiName + "?" + params, true);
    xhttp.send();
}


/**
 * Handler for Collapsable panel
 * @private
 */
function _panelClickHandler() {
    this.classList.toggle("panel-header-active");
    const panel = this.nextElementSibling;
    if (panel.style.maxHeight) {
        panel.style.maxHeight = null;
    } else {
        panel.style.maxHeight = panel.scrollHeight + "px";
    }
}


/**
 * Insert handles on collapsable panels containing class "panel-header"
 */
function commonToolsAddCollapsablePanelsHandlers() {
    // console.log("commonToolsAddCollapsablePanelsHandlers...");
    const acc = document.getElementsByClassName("panel-header");
    let i;
    for (i = 0; i < acc.length; i++) {
        // This is javascript. Grant that we have only one listener.
        acc[i].removeEventListener("click", _panelClickHandler);
        acc[i].addEventListener("click", _panelClickHandler);
        // console.log("commonToolsAddCollapsablePanelsHandlers add click handler...");
        if (acc[i].getAttribute("is_open") === "true") {
            acc[i].click();
            acc[i].removeAttribute("is_open");
        }
    }
}


/**
 * Update the panel height contain the given element.
 * Must be called every time that content grows height.
 * @param contentElem
 */
function commonToolsUpdatePanelHeightForElem(contentElem) {
    const MAX_DEEP = 20;
    let deep = 0;
    let parentElem = contentElem.parentElement;
    while (parentElem && deep < MAX_DEEP) {
        if (parentElem.getAttribute("class") && parentElem.getAttribute("class").includes("panel-body")) {
            const panelHeaderElem = parentElem.previousElementSibling;
            // Simulates a close and open panel
            panelHeaderElem.click();
            panelHeaderElem.click();
            return;
        }
        parentElem = parentElem.parentElement;
        deep++;
    }
    if (deep > MAX_DEEP) {
        console.error("commonToolsUpdatePanelHeightForElem. Max deep reached. deep=", deep, ", element id=", contentElem.id);
    }
}


/**
 * Update the panel height contain the given element id.
 * Must be called every time that content grows height.
 * @param elementId
 */
function commonToolsUpdatePanelHeightForId(elementId) {
    const element = document.getElementById(elementId);
    if (element)    {
        commonToolsUpdatePanelHeightForElem(element);
    } else  {
        console.error("Element not found", elementId);
    }
}


/**
 * Represent a date in ISO format with time zone
 * @param date
 * @returns {string}
 */
function commonToolsDateToIsoStringWithTZ(date) {
    let tzo = -date.getTimezoneOffset(),
        dif = tzo >= 0 ? ' +' : ' -',
        pad = function (num) {
            let norm = Math.floor(Math.abs(num));
            return (norm < 10 ? '0' : '') + norm;
        };
    return date.getFullYear() +
        '-' + pad(date.getMonth() + 1) +
        '-' + pad(date.getDate()) +
        ' ' + pad(date.getHours()) +
        ':' + pad(date.getMinutes()) +
        ':' + pad(date.getSeconds()) +
        dif + pad(tzo / 60) +
        ':' + pad(tzo % 60);
}


/**
 * Send the master volume value to backend and set the volume in alsamixer
 */
function onMasterVolumeChange() {
    let masterVolumeSlider = document.getElementById("master-vol");
    if (masterVolumeSlider) {
        let masterVolumeSliderValue = document.getElementById("master-vol-value");
        if (masterVolumeSliderValue) {
            masterVolumeSliderValue.classList.remove("slider-is-moving");
        }
        let volume = masterVolumeSlider.value;
        const CGI_NAME = "mastervolume.cgi";
        const params = "value=" + volume;
        commonToolsSendXMLHttpGetRequest("/cgi-bin/" + CGI_NAME, params);
    }
}


/**
 * Send the sonic IP volume value to backend and set the UCI var
 */
function onSonicIpVolumeChange() {
    let sonicIpVolumeSlider = document.getElementById("sonicip-vol");
    if (sonicIpVolumeSlider) {
        let sonicIpVolumeSliderValue = document.getElementById("sonicip-vol-value");
        if (sonicIpVolumeSliderValue) {
            sonicIpVolumeSliderValue.classList.remove("slider-is-moving");
        }
        let volume = sonicIpVolumeSlider.value;
        const CGI_NAME = "sonicipvolume.cgi";
        const params = "value=" + volume;
        commonToolsSendXMLHttpGetRequest("/cgi-bin/" + CGI_NAME, params);
    }
}

/**
 * Update the slider value on the id "<GIVEN_ID>-value"
 * @param sliderId
 */
function onSliderInput(sliderId) {
    let slider = document.getElementById(sliderId);
    if (slider) {
        let volume = slider.value;
        let sliderValue = document.getElementById(sliderId + "-value");
        sliderValue.classList.add("slider-is-moving");
        sliderValue.innerHTML = volume + "%";
    }
}