// Endpoint to obtain the configuration values from UCI in JSON format
const CRT_LIST_ENDPOINT = "/cgi-bin/certificateList.cgi";

// List Files holder (JSON format)
let crtListJson;

/**
 * Obtain a sources config using ajax. NOTE: this method is synchronous.
 */
function getFileList() {
    if (!crtListJson) {
        commonToolsReadJsonFile(CRT_LIST_ENDPOINT, false, function (content) {
            crtListJson = JSON.parse(content);
            // console.log("crtListJson:", crtListJson);
        });
    }
    return crtListJson;
}

let _certificatesToBeRemoved = [];

/**
 * Check if the number is odd
 * @param num
 * @returns {boolean}
 */
function isOdd(num) {
    return (num % 2) === 1;
}


function _clearSelectAllFiles(scope) {
    switch (scope) {
        case "custom":
            _certificatesToBeRemoved = [];
            break;
    }
}


function _enableDeleteButton(scope, enabled) {
    const deleteButtonElem = document.getElementById("button_delete_" + scope);
    deleteButtonElem.disabled = !enabled;
}


function _addCtrToBeRemoved(scope, fileName) {
    switch (scope) {
        case "custom":
            _certificatesToBeRemoved.push(fileName);
            // console.log("certificateToBeRemovedCustom=", _certificatesToBeRemoved);
            break;
    }
    _enableDeleteButton(scope, true);
}


function _removeFileToBeRemoved(scope, fileName) {
    let index;
    // console.log("scope=", scope);
    switch (scope) {
        case "custom":
            index = _certificatesToBeRemoved.indexOf(fileName);
            if (index > -1) {
                _certificatesToBeRemoved.splice(index, 1);
            }
            if (_certificatesToBeRemoved.length === 0) {
                _enableDeleteButton(scope, false);
            }
            // console.log("certificatesToBeRemovedInternal=", _certificatesToBeRemoved);
            break;
    }
}


function _allCertificatesCheck(scope, checked) {

    if (checked) {
        _clearSelectAllFiles(scope);
    }

    let selection = document.getElementsByTagName("input");
    for (let i = 0; i < selection.length; i++) {
        if (selection[i].type === "checkbox" && selection[i].hasAttribute("www-data-scope") && selection[i].getAttribute("www-data-scope") === scope) {
            selection[i].checked = checked;
            if (checked) {
                _addCtrToBeRemoved(scope, selection[i].getAttribute("www-data-name"));
            } else {
                _removeFileToBeRemoved(scope, selection[i].getAttribute("www-data-name"));
            }
        }
    }
}


function selectAllFilesHandler(scope) {
    _allCertificatesCheck(scope, true);
}


function selectNoneCertificatesHandler(scope) {
    _allCertificatesCheck(scope, false);
}


function deleteSelectedCertificatesHandler(scope) {
    _deleteConfirmAndDelete(scope);
}


function _renderButton(label, id, clickHandler) {
    let buttonElem = document.createElement("input");
    buttonElem.setAttribute("style", "font-size: 12px; height: 21px; padding: 0 4px; margin: 4px;");
    buttonElem.type = ("button");
    buttonElem.id = id;
    buttonElem.value = label;
    buttonElem.addEventListener('click', clickHandler);
    return buttonElem;
}


function _deleteConfirmAndDelete(scope) {

    let files = "\n• ";
    const filesListAsStringElem = document.getElementById("delete_" + scope + "_list");
    switch (scope) {
        case "custom":
            if (_certificatesToBeRemoved.length === 0) {
                notify.notify({message: 'Please select the certificates to be removed first', level: 'warning'});
                return;
            }
            files += _certificatesToBeRemoved.join("\n• ");
            filesListAsStringElem.value = _certificatesToBeRemoved.join(";");
            break;
    }
    if (confirm("Are you sure you want to delete the " + scope + " certificates?\n" + files)) {
        const form = document.getElementById("delete_" + scope + "_form");
        form.submit();
        commonToolsShowElemId("loading-spinner");
        commonToolsHideElemId("page-content");
    }
}


function renderCertificateGroup(scope, fileArray) {

    const containerDivElem = document.createElement("div");
    containerDivElem.setAttribute("style", "padding: 8px;");

    // Buttons
    const buttonsDivElem = document.createElement("div");
    buttonsDivElem.setAttribute("style", "margin-bottom: 4px;");

    const formDeleteElem = document.createElement("form");
    formDeleteElem.id = "delete_" + scope + "_form";
    formDeleteElem.name = "delete_" + scope + "_form";
    formDeleteElem.action = "delete_certificates.cgi";
    formDeleteElem.setAttribute("class", "");
    formDeleteElem.method = "POST";

    const filesListAsString = document.createElement("input");
    filesListAsString.type = ("hidden");
    filesListAsString.id = "delete_" + scope + "_list";
    filesListAsString.name = "delete_" + scope + "_list";
    formDeleteElem.appendChild(filesListAsString);

    const return_page = document.createElement("input");
    return_page.type = ("hidden");
    return_page.id = "return_page";
    return_page.name = "return_page";
    return_page.value = "settings_ui.cgi";
    formDeleteElem.appendChild(return_page);

    const selectAllButtonElem = _renderButton("select all", "", function () {
        selectAllFilesHandler(scope);
    });

    const selectNoneButtonElem = _renderButton("select none", "", function () {
        selectNoneCertificatesHandler(scope);
    });

    const deleteSelectedButtonElem = _renderButton("delete selected", "button_delete_" + scope, function () {
        //commonToolsShowElemId("loading-spinner");
        //commonToolsHideElemId("page-content");
        deleteSelectedCertificatesHandler(scope);
    });
    deleteSelectedButtonElem.disabled = true;
    deleteSelectedButtonElem.style.setProperty('margin-left', "128px");
    deleteSelectedButtonElem.style.setProperty('type', "button");

    formDeleteElem.appendChild(selectAllButtonElem);
    formDeleteElem.appendChild(selectNoneButtonElem);
    formDeleteElem.appendChild(deleteSelectedButtonElem);
    buttonsDivElem.appendChild(formDeleteElem);

    containerDivElem.appendChild(buttonsDivElem)

    const mediaTable = document.createElement("table");
    mediaTable.setAttribute("cellspacing", "0");
    mediaTable.setAttribute("cellpadding", "0");
    mediaTable.setAttribute("class", "labelValue");
    mediaTable.setAttribute("style", "border-collapse: collapse;");

    if (fileArray.length === 0) {
        const noFilesDivElem = document.createElement("div");
        noFilesDivElem.setAttribute("class", "section2");
        noFilesDivElem.setAttribute("style", "font-size: 13px; font-style: italic; padding: 4px; color: #888888;");
        noFilesDivElem.innerText = "(no certificates installed)";
        return noFilesDivElem;
    }

    // Render table header
    const rowHeader = mediaTable.insertRow(-1);
    rowHeader.setAttribute("style", "color: #888888; font-size: 13px;");
    const headerCheckedCellElem = rowHeader.insertCell(-1);
    // const headerSizeCellElem = rowHeader.insertCell(-1);
    // headerSizeCellElem.innerText = "size";

    const headerNameCellElem = rowHeader.insertCell(-1);
    headerNameCellElem.innerText = "certificate";

    const headerStatusCellElem = rowHeader.insertCell(-1);
    headerStatusCellElem.innerText = "status";
    // Render file list
    for (let i = 0; i < fileArray.length; i++) {
        let file = fileArray[i];
        const rowMediaFile = mediaTable.insertRow(-1);
        if (isOdd(i + 1)) {
            rowMediaFile.setAttribute("style", "background-color: rgb(0,0,0,0.03);");
        } else {
            rowMediaFile.setAttribute("style", "background-color: transparent;");
        }
        // CheckBox
        const fileButtonRemoveCellElem = rowMediaFile.insertCell(-1);
        let checkBoxElem = document.createElement("input");
        checkBoxElem.title = "Selection for delete";
        checkBoxElem.setAttribute("type", "checkbox");
        checkBoxElem.setAttribute("style", "margin-right: 8px");
        checkBoxElem.setAttribute("www-data-scope", scope);
        checkBoxElem.setAttribute("www-data-name", file.name);

        checkBoxElem.addEventListener('change', (event) => {
            if (event.target.checked) {
                // alert('checked ' + file.name);
                _addCtrToBeRemoved(scope, file.name)
            } else {
                // alert('not checked ' + file.name);
                _removeFileToBeRemoved(scope, file.name)
            }
        })
        fileButtonRemoveCellElem.appendChild(checkBoxElem);

        // Size
        // const fileSizeCellElem = rowMediaFile.insertCell(-1);
        // fileSizeCellElem.innerHTML = file.size;
        // fileSizeCellElem.setAttribute("class", "label");
        // fileSizeCellElem.setAttribute("style", "min-width: unset; font-size: 13px; text-align: right;");

        // Name
        const fileNameCellElem = rowMediaFile.insertCell(-1);
        fileNameCellElem.innerText = file.name;
        fileNameCellElem.setAttribute("class", "value");
        fileNameCellElem.setAttribute("style", "min-width: 300px; font-size: 13px; width: 99%");

        // State
        var notInstalled = false;
        const fileStateCellElem = rowMediaFile.insertCell(-1);
        if (file.state) {
            fileStateCellElem.innerHTML = file.state.toLowerCase();
            if (file.state !== "INSTALLED") {
                //fileStateCellElem.setAttribute("style", "color: #A21010");
                notInstalled = true;
            }
        } else  {
            fileStateCellElem.innerHTML = "unknown";
        }
        fileStateCellElem.setAttribute("class", "label");
        var style = fileStateCellElem.getAttribute("style");
        if (notInstalled) {
            fileStateCellElem.setAttribute("style", "min-width: unset; font-size: 13px; color: #A21010;");
        } else {
            fileStateCellElem.setAttribute("style", "min-width: unset; font-size: 13px;");
        }
        

    }
    containerDivElem.appendChild(mediaTable)
    return containerDivElem;
}


/**
 * Render the report for one source
 */
function renderCertificateList() {

    getFileList();

    const mediaDivElem = document.getElementById('certificate-list');
    if (mediaDivElem) {

        // const headerInternalElem = document.createElement("h4");
        // headerInternalElem.innerText = "Custom";
        // mediaDivElem.appendChild(headerInternalElem);
        const mediaInternal = renderCertificateGroup("custom", crtListJson.custom);
        mediaDivElem.appendChild(mediaInternal);
        mediaDivElem.setAttribute("style", "border: solid 1px #CCCCCC; border-radius: 4px;");

    } else {
        console.error("ERROR! Element can't be deployed! Please, clear browser cache and reload.");
    }
}
