<% . /usr/local/lib/cgi/generic.sh ; print_http_hdr %>
<% . /usr/local/lib/cgi/status.sh %>
<%

VERSION=$(cat /barix/info/VERSION)

# Update theme symbolic link
rm -Rf /usr/local/www/current/theme
if [ -d "/usr/local/www/current/app/theme" ]; then
    ln -s /usr/local/www/current/app/theme /usr/local/www/current/theme
else
    ln -s /usr/local/www/current/themes/barix-default /usr/local/www/current/theme
fi


# Extract application name from manifest
if test -f "/usr/local/www/current/app/scripts/getApplicationName.sh"; then
    APP_NAME="$(bash /usr/local/www/current/app/scripts/getApplicationName.sh)"
else
    APP_NAME=`jq -j .name /mnt/data/package/manifest.json`
fi

if [ -z "${APP_NAME}" ]; then
    APP_NAME="Barix Device";
fi


DEVICE_ALIAS=$(echo "$(uci get device.device.alias)")
if [ ! -z "${DEVICE_ALIAS}" ]; then
    APP_NAME="${APP_NAME} | ${DEVICE_ALIAS}"
fi


# Validate manifest
#if test -f "/usr/local/www/current/app/scripts/manifestValidation.sh"; then
#    #/usr/bin/python3 /usr/local/www/current/app/scripts/manifestValidation.py
#    bash /usr/local/www/current/app/scripts/manifestValidation.sh
#    MANIFEST_OK=$?
#else
#    /usr/bin/python3 /usr/local/www/current/scripts/firmware-version.py
#    MANIFEST_OK=$?
#fi
MANIFEST_OK=0



# Checks whether there is a configuration file for the menu
HAS_MENU_JSON_FILE="false"
[ -f /usr/local/www/current/app/menu.json ] && HAS_MENU_JSON_FILE="true";


# Sample of app/menu.json
# - Set the default page "Settings"
# - Add a tab "Sources" with a link to content
# - Remove the standard menu options "Update and "Reboot".
#
# {
#   "default": "Settings"
#   "add": [
#     {
#       "label": "Sources",
#       "link": "app_sources.html"
#       "title": "The sources menu item title"
#     }
#   ],
#   "remove":   [
#     "Update",
#     "Reboot"
#   ]
# }
%>


<html lang="en_US">
<head>
    <title>Main Menu</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">

    <style>

        ul.main-menu {
            display: block;
            list-style-type: disc;
            margin-block-start: 0;
            margin-block-end: 0;
            margin-inline-start: 0;
            margin-inline-end: 0;
            padding-inline-start: 0;
        }

        li.main-menu {
            float: left;
            display: inline-block;
            text-align: center;
            min-width: 75px;
            padding: 0 4px;
        }

    </style>

    <link href="/theme/css/main.css" rel="stylesheet" type="text/css">
    <!-- Notification Popup -->
    <link rel="stylesheet" href="/theme/css/notify.css">
    <script src="/notify/notify.js"></script>
    <script type="text/javascript" >
        function showNotification() {
            <%  if [ "$FORM_notification" != "" ] ; then
                    echo -n "notify.notify({message:'$FORM_notification', level:'good'});"
                fi
            %>
        }
    </script>

    <script>

        const VERSION="<% echo -n $VERSION %>";

        var lastLinkClick = new Date(0);

        function alignNavBar() {
            /*
            This function adjusts the gray/red separator and view and help
            frames width
            */
            let span = 0;
            const theNavbarRow = document.getElementById('navbar');
            const rowChildren = theNavbarRow.childNodes.length;
            let currentChild;
            for (let i = 0; i < rowChildren; i++) {

                currentChild = theNavbarRow.childNodes[i];

                // do not count anymore, we've reached the
                // end of the navigation bar
                if (currentChild.id === 'end_navbar') {
                    break;
                }

                // Count the headers and cells
                if (currentChild.nodeName === 'TH' || currentChild.nodeName === 'TD') {
                    span = span + 1;
                }
            }

            // Set the span of the grey/red separator and the app name/barix logo
            document.getElementById('app_name_span').colSpan = span;
            document.getElementById('navbar_separator').colSpan = span;
        }

        // returns true if last menu link click
        // was done within certain amount of time
        function check_cgi_click(delay) {
            const currentTime = new Date();
            const oldLinkClick = lastLinkClick;
            let tmpCt = parseInt(currentTime.valueOf());
            let tmpOlc = parseInt(oldLinkClick.valueOf());
            lastLinkClick = currentTime;
            const tmpRes = tmpOlc + parseInt(delay);
            return tmpRes < tmpCt;
        }

        function open_link(delay, link) {
            let end_link = location.protocol + '//' + window.location.hostname;
            const port = window.location.port;
            if (port) {
                end_link = end_link + ':' + port + link;
            } else {
                end_link = end_link + link;
            }
            if (check_cgi_click(delay)) {
                window.open(end_link, "tab");
            }
        }

        function check_title()  {
            let version="<% print_app_version | grep -Fq "S" && echo -n " S" || echo -n "" %>";
            if (version !== ""){
                top.document.getElementsByTagName('title')[0].innerHTML="Development Kit";
            }
        }

        var menuOptionsJson;

        function getMenuOptionsAsJson()  {
            if ( ! menuOptionsJson )  {
                readJsonFile("../app/menu.json", function(content) {
                    menuOptionsJson = JSON.parse(content);
                    console.log(menuOptionsJson);
                    let hwType = "<% echo -n $(/usr/bin/qiba-spi-get-production-info.sh -w) %>";
                    if (hwType === "68"){
                        menuOptionsJson['add'].pop();
                    }
                });
            }
            return menuOptionsJson;
        }

        function renderMenuOption(label, link, title)  {
            let liNode = document.createElement("LI");
            liNode.setAttribute("class", "main-menu");
            if (title)  {
                liNode.title = "" + title;
            }
            liNode.innerHTML = ' <a href="javascript:void(0)" class="main-menu" target="tab" onclick="selectMenuOption(\''+label+'\')" content-link="'+link+'?v=' + VERSION + '"><div id="menu_'+label+'" class="main-menu">' + label + '</div></a>';
            ulElem = document.getElementById("main-menu");
            ulElem.appendChild(liNode);
        }

        function renderExtraMenuEntries()   {
            var data = getMenuOptionsAsJson();
            if (data && data.add)    {
                let len = Object.keys(data.add).length;
                for (let i=0; i<len; i++) {
                    renderMenuOption(data.add[i].label, '/app/'+data.add[i].link, data.add[i].title);
                }
            }
        }

        function canBeShowed(label) {
            var data = getMenuOptionsAsJson();
            if (data && data.remove)    {
                let len = Object.keys(data.remove).length;
                for (let i=0; i<len; i++) {
                    if (label === data.remove[i])   {
                        return false;
                    }
                }
            }
            return true;
        }

        function getDefaultMenuOption() {
            var data = getMenuOptionsAsJson();
            if (data && data.default)    {
                return data.default;
            }
            return "Home"
        }

        function renderBaseMenuOption(label, link, title) {
            if (canBeShowed(label)) {
                renderMenuOption(label, link, title);
            }
        }

        function readJsonFile(file, callback) {
            if (<% echo -n "$HAS_MENU_JSON_FILE" %>)   {
                var rawFileRequest = new XMLHttpRequest();
                rawFileRequest.overrideMimeType("application/json");
                rawFileRequest.open("GET", file + "?_=" + new Date().getTime(), false);
                rawFileRequest.onreadystatechange = function() {
                    if (rawFileRequest.readyState === 4 && rawFileRequest.status == "200") {
                        callback(rawFileRequest.responseText);
                    }
                }
                rawFileRequest.send(null);
            } else  {
                callback("{}");
            }
        }

        function menuHighLight(option) {
            let defOption = option;
            let ulElem = document.getElementById('main-menu');
            let children = ulElem.children;
            let child;
            for (child in children) {
                if (children[child].firstElementChild && children[child].firstElementChild.firstElementChild) {
                    children[child].firstElementChild.firstElementChild.classList.remove("main-menu-active");
                }
            }

            let element = document.getElementById("menu_" + defOption);
            if (! element)  {
                let defaultMenuOption =  getDefaultMenuOption();
                element = document.getElementById("menu_" + defaultMenuOption);
                defOption = defaultMenuOption;
            }
            element.classList.add("main-menu-active");
            active_menu = defOption
        }

        function getMenuLinkFor(label)   {
            let actDivElem = document.getElementById("menu_" + label);
            let actAElem = actDivElem.parentElement;
            if (actAElem)   {
                let link = actAElem.getAttribute("content-link");
                if (link)   {
                   return link;
                }
            }
            return "/";
        }

        function selectMenuOption(label) {
            let defOption = label;
            let ulElem = document.getElementById('main-menu');
            let children = ulElem.children;
            let child;

            // Remove active from all menu options
            for (child in children) {
                if (children[child].firstElementChild && children[child].firstElementChild.firstElementChild) {
                    let aElem = children[child].firstElementChild;
                    let divElem = aElem.firstElementChild;
                    divElem.classList.remove("main-menu-active");
                }
            }

            // Set active to selected option
            let actDivElem = document.getElementById("menu_" + defOption);
            if (! actDivElem)  {
                let defaultMenuOption =  getDefaultMenuOption();
                actDivElem = document.getElementById("menu_" + defaultMenuOption);
                defOption = defaultMenuOption;
            }
            actDivElem.classList.add("main-menu-active");
            active_menu = defOption;

            open_link(1000, getMenuLinkFor(defOption));

        }

        function renderMenu()   {

            renderBaseMenuOption("Home", "/cgi-bin/Flexa_home_frame.cgi", "Application status and management");

            <% if [ $MANIFEST_OK -eq 0 ]; then
                 echo 'renderBaseMenuOption( "Settings", "/cgi-bin/settings_frame.cgi", "Configure device settings");';
                 echo 'renderExtraMenuEntries();';
               else
                 echo "$(date +%Y-%m-%d %H:%M:%S) [ERROR]  Firmware doesn't match with Manifest. (status=$MANIFEST_OK)" >> /var/log/firmware-manifest.log
               fi %>

            renderBaseMenuOption("Status", "/cgi-bin/status_ui.cgi", "Show system status and info");
            renderBaseMenuOption("Logs", "/cgi-bin/logs_ui.cgi", "View system logs");
            renderBaseMenuOption("Defaults", "/cgi-bin/defaults_frame.cgi", "Reset to factory defaults");
            renderBaseMenuOption("Update", "/cgi-bin/update_frame.cgi", "Update firmware and install licences");
            renderBaseMenuOption("Reboot", "/cgi-bin/reboot_frame.cgi", "Reboot system");

            alignNavBar();
            selectMenuOption(getDefaultMenuOption());

        }

        function onLoadScriptsAndFunctions() {
            renderMenu();
        }

        <% echo -e "window.parent.document.title=\"$APP_NAME\"" %>

    </script>

</head>
<body class="main-menu" onload="onLoadScriptsAndFunctions()">
    <table class="main-menu" cellpadding="0" cellspacing="0">

        <tr id="navbar" class="main-menu">
            <th class="main-menu">
                <ul id="main-menu" class="main-menu">
                </ul>
            </th>
            <th id="end_navbar" class="main-menu main-menu-contrast main-menu-hdwr-info">
                <% print_device_type %>&nbsp;&nbsp;MAC <% print_mac_addr %>&nbsp;FW <% print_fw_version %>
            </th>
        </tr>

        <tr>
            <td id="app_name_span" class="product">
                <% echo -n "${APP_NAME}" %>
                <%
                    ALIAS=$(cfg_print_param device.device.alias)
                    if [ ! -z ${var+x} ]; then
                        echo -n "| ${ALIAS}"
                    fi
                %>
                <% if [ $MANIFEST_OK -ne 0 ]; then
                     # echo "<span style=\"font-size: 14; color: red; padding-left: 1em;\"> Application was not made to work with current firmware image and it might not work.</span>";
                     echo -n "<script>notify.notify({message:'Application was not made to work with current firmware image and it might not work.', level:'danger', autoDismissing: false})</script>";
                   fi %>
            </td>
            <td align="right" style="padding-right: 8px;">
                <a href="https://www.barix.com" target="_blank">
                    <img src="/theme/images/brand.png?v=<% echo -n $VERSION %>">
                </a>
            </td>
        </tr>

        <tr class="navbar-separator">
            <td id="navbar_separator" class="main-menu"</td>
            <td class="main-menu-contrast"></td>
        </tr>
    </table>
</body>
</html>
