#!/usr/bin/haserl --upload-limit=10240 --upload-dir=/tmp/
content-type: text/html

<% if [ "$FORM_return_page"X = "X" ] ; then FORM_return_page="Flexa_home.cgi"; fi %>

<% VERSION=$(cat /barix/info/VERSION) %>

<html lang="en_US">
<head>
    <title>Upload</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="/javascript/modal.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" >
        function goToUrl(url, milliseconds)  {
            setTimeout(function(){ window.location.href = url; }, milliseconds);
        }
    </script>
</head>
<body>
        <% if [ -f "${FORM_uploadfileapp}" ];then %>
            <%
                /usr/bin/flexa-agent install "${FORM_uploadfileapp}" "${FORM_upload_app_version}" > /dev/null 2>&1
                ret=$?
            %>
            <% if [ $ret -eq 0 ]; then %>
                <% /etc/init.d/run-flexa start > /dev/null 2>&1 %>
                <script type="text/javascript" >
                    goToUrl("<% echo -n "${FORM_return_page}?notification=Package was successfully installed!&refreshInterval=3000" %>", 0);
                </script>

            <% elif [ $ret -eq 2 ]; then %>
                <script type="text/javascript" >
                    goToUrl("<% echo -n "${FORM_return_page}?notification=Error decompressing the package!&level=danger" %>", 0);
                </script>

            <% elif [ $ret -eq 4 ]; then %>
                <script type="text/javascript" >
                    goToUrl("<% echo -n "${FORM_return_page}?notification=Package is similar to the one already installed!&level=warning" %>", 0);
                </script>

            <% fi %>
        <% elif [ -f "${FORM_uploadfileconf}" ]; then %>
            <%
                /usr/bin/flexa-agent config "${FORM_uploadfileconf}" > /dev/null 2>&1
                ret=$?
            %>
            <% if [ $ret -eq 0 ]; then %>
                <script type="text/javascript" >
                    goToUrl("<% echo -n "${FORM_return_page}?notification=Configuration file is loaded!" %>", 0);
                </script>

            <% elif [ $ret -eq 2 ]; then %>
                <script type="text/javascript" >
                    goToUrl("<% echo -n "${FORM_return_page}?notification=Error parsing the configuration file or it is empty!&level=danger" %>", 0);
                </script>

            <% elif [ $ret -eq 3 ]; then %>
                <script type="text/javascript" >
                    goToUrl("<% echo -n "${FORM_return_page}?notification=Configuration file is similar to the one already installed!&level=warning" %>", 0);
                </script>

            <% else %>
                <script type="text/javascript" >
                    goToUrl("<% echo -n "${FORM_return_page}?notification=Error installing the configuration file!&level=danger" %>", 0);
                </script>

            <% fi %>
        <% else %>
            <div class="section1">
                    <p style="color: red;">Error while uploading the file &quot;<b><% echo -n $FORM_uploadfileapp_name %></b>&quot;.</p>
            </div>
            <p><br/></p>
            <div class="section1">
                <input type="button" value="Return to home" onclick="goToUrl('<% echo -n "${FORM_return_page}" %>')"/>
            <div>
        <% fi %>
</body>
</html>
