<% . /usr/local/lib/cgi/haserl.sh ; check_instances Flexa_home.cgi %>
<% . /lib/config/functions.sh
VERSION=$(cat /barix/info/VERSION)
%>

<html lang="en_US">
<head>
    <title>Flexa Home</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <link href="/theme/css/modal.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="/javascript/common-tools.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/modal.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/flexa-home.js?v=<% echo -n $VERSION %>"></script>

    <% [ ! -f /usr/local/www/current/app/javascript/app_home.js ] && echo -n '<!-- ' %>
    <script type="text/javascript" src="/app/javascript/app_home.js?v=<% echo -n $VERSION %>"></script>
    <% [ ! -f /usr/local/www/current/app/javascript/app_home.js ] && echo -n ' -->' %>
    <!-- Notification Popup -->
    <link rel="stylesheet" href="/theme/css/notify.css?v=<% echo -n $VERSION %>">
    <script src="/notify/notify.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" >
        function showNotification() {
            <%  if [ "$FORM_notification" != "" ] ; then
                    if [ -z ${FORM_level+x} ]; then
                        echo -n "notify.notify({message:'$FORM_notification', level:'good'});"
                    else
                        echo -n "notify.notify({message:'$FORM_notification', level:'$FORM_level'});"
                    fi
                fi
            %>
        }
        function testRefreshParent() {
            <%  if [ -n "$FORM_refreshInterval" ] ; then
                    if [ "$FORM_refreshInterval" != "0" ] ; then
                        echo -n "setTimeout(function() { window.open('/cgi-bin/menu.cgi?v="; echo -n $VERSION;
                        echo -n "', 'menu'); }, "; echo -n $FORM_refreshInterval; echo -n ");"
                    else
                        echo -n "window.open('/cgi-bin/menu.cgi?v="; echo -n $VERSION; echo -n "', 'menu');"
                    fi
                fi
            %>
        }
    </script>
</head>

<body onload="commonToolsIncludeHTML();startStatusPolling();showNotification();testRefreshParent();">

    <h2>Flexa Home</h2>

    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_home_top.cgi ] && echo -n '<!-- ' %>
    <div include-html="/app/cgi-bin/app_home_top.cgi"></div>
    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_home_top.cgi ] && echo -n ' -->' %>

    <h3>Device Status</h3>
    <div class="section1">
        <table class="labelValue">
            <colgroup>
                <col class="label">
                <col class="value">
            </colgroup>
            <tbody>
                <tr>
                    <td class="label">Registration ID</td>
                    <td class="value value2" id="regid"><% cfg_print_param flexa_agent.registry.regid%></td>
                </tr>
                <tr>
                    <td class="label">Service URL</td>
                    <td class="value value2" id="service_url"><% cfg_print_param flexa_agent.service.service_url%></td>
                </tr>
                <tr>
                    <td class="label">Package Version</td>
                    <td class="value value2" id="package_version"><% cfg_print_param flexa_agent.service.package_version%></td>
                </tr>
                <tr>
                    <td class="label">Application Status</td>
                    <td class="value value2" id=player_state></td>
                </tr>

                <form name="flexa-home" id="flexa-home-form" action="config.cgi" method="POST">
                    <tr id="row-flexa_agent.service.enabled">
                        <td class="flexa-application label-sec2">Flexa Agent</td>
                        <td class="flexa-application value">
                            <select class="shortText" id="flexa_agent.service.enabled" name="flexa_agent.service.enabled" onchange="submitChanges(this.value)">
                                <option value="true" <% if cfg_string_compare flexa_agent.service.enabled true ; then echo -n 'selected="selected"'; fi %>>Enabled</option>
                                <option value="false" <% if cfg_string_compare flexa_agent.service.enabled false ; then echo -n 'selected="selected"'; fi %>>Disabled</option>
                            </select>
                        </td>
                    </tr>
                    <input type="hidden" name="return_page" value="Flexa_home.cgi">
                </form>
            </tbody>
        </table>
    </div>

    <h3>Flexa Application</h3>
    <div class="section1">
        <table class="flexa-service">
            <colgroup>
                <col class="label">
                <col class="value">
            </colgroup>
            <tbody>
                <tr>
                    <td class="flexa-application">
                        <button class="red" onclick="stopAppConfirm()">Stop App</button>
                        <button class="green" onclick="sendSingleCommand('app_start=1')">Start App</button>
                        <button onclick="sendSingleCommand('sync=1')">Sync</button>
                        <button onclick="reconnectConfirm()">Reconnect</button>
                    </td>
                </tr>
            </tbody>
        </table>
        <table class="flexa-service">
            <colgroup>
                <col class="label">
                <col class="value">
            </colgroup>
            <tbody>
                <tr>
                    <td class="flexa-application">Install Package</td>
                    </td>
                    <td class="flexa-application">
                        <button id="new-app-button" onclick="uploadHandler('upload-app-modal');" title="Upload package file">Upload</button>
                    </td>
                </tr>
                <tr>
                    <td class="flexa-application">Configuration File</td>
                    </td>
                    <td class="flexa-application">
                        <button id="new-conf-button" onclick="uploadHandler('upload-conf-modal');" title="Upload configuration file">Upload</button>
                    </td>
                    <td>
                        <form action="Flexa_download_config.cgi" method="get" style="margin: 0;">
                            <input type="submit" value="Download" title="Download configuration file"/>
                        </form>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>



    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_home_bottom.cgi ] && echo -n '<!-- ' %>
    <div include-html="/app/cgi-bin/app_home_bottom.cgi?v=<% echo -n $VERSION %>"></div>
    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_home_bottom.cgi ] && echo -n ' -->' %>

    <% # A hack to send GET commands to backend %>
    <img class="send-cmd-img" name="senddataimg" src="">

     <!-- CONTENT OF UPLOAD MODALS -->
     <div id="upload-app-modal" style="display: none;">
         <div template="title">
             Install Package
         </div>
         <div template="body">
             <form id="upload-app-form" name="upload-form" action="Flexa_upload.cgi" class="upload-form" style="width: 100%;" method="POST" enctype="multipart/form-data">
                 <input type="hidden" name="return_page" value="Flexa_home.cgi">
                 <table class="section1" cellspacing="0" cellpadding="3" align="center" style="width: 96%; height: 120px;">
                     <tbody>
                         <tr>
                             <td style="vertical-align: bottom;">
                                 <input id="filename-app" type="file" accept=".zip,.tar,.tar.gz,tar.bz2" name="uploadfileapp" onchange="checkFilename(this, 'upload-app-button')" style="width: 100%;"/>
                             </td>
                         </tr>
                         <tr>
                             <td>Application Version: <input name="upload_app_version" class="mediumText" maxlength="12" value="<% cfg_print_param flexa_agent.service.package_version %>"/>
                             </td>
                         </tr>
                         <tr>
                             <td style="text-align: right; vertical-align: bottom;">
                                 <button id="upload-app-button" type="submit" disabled="disabled" title="Upload application package" onclick="closePopup('upload-app-modal');">Upload and Install</button>
                             </td>
                         </tr>
                     </tbody>
                 </table>
             </form>
         </div>
     </div>

     <div id="upload-conf-modal" style="display: none;">
         <div template="title">
             Load Configuration File
         </div>
         <div template="body">
             <form id="upload-conf-form" name="upload-form" action="Flexa_upload.cgi" class="upload-form" style="width: 100%;" method="POST" enctype="multipart/form-data">
                 <input type="hidden" name="return_page" value="Flexa_home.cgi">
                 <table class="section1" cellspacing="0" cellpadding="3" align="center" style="width: 96%; height: 120px;">
                     <tbody>
                         <tr>
                             <td style="vertical-align: bottom;">
                                 <input id="filename-conf" type="file" accept=".json" name="uploadfileconf" onchange="checkFilename(this, 'upload-conf-button')" style="width: 100%;"/>
                             </td>
                         </tr>
                         <tr>
                             <td style="text-align: right; vertical-align: bottom;">
                                 <button id="upload-conf-button" type="submit" disabled="disabled" title="Load Configuration File" onclick="closePopup('upload-conf-modal');">Upload</button>
                             </td>
                         </tr>
                     </tbody>
                 </table>
             </form>
         </div>
     </div>


</body>
</html>
