#!/bin/bash

#
# This script will be called whenever a form is submitted.
# Parameters:
#   1 - Name of changed UCI variable
#   2 - Old UCI value
#   3 - New UCI value
#
# Stdout will show as WebUI waiting messages.
#
# Exit status:
#   0 - Configuration applied normally.
#   1 - Configuration applied. Service need to be restarted.
#   2 - Configuration applied. Service need to be restarted. Http protocol changed.
#   9 - Configuration applied. Reboot needed.

RESTART_APPS_DIR="/tmp/90s-ui/restart-apps"

UCI_KEY=${1}
UCI_OLD_VAL=${2}
UCI_NEW_VAL=${3}

UCI_CONFIG=$( echo ${UCI_KEY} | awk -F '.' '{printf $1;}')
UCI_SECTION=$( echo ${UCI_KEY} | awk -F '.' '{printf $2;}')
UCI_OPTION=$( echo ${UCI_KEY} | awk -F '.' '{printf $3;}')


# DEBUG
#echo "${UCI_KEY} = \"${UCI_OLD_VAL}\" -> \"${UCI_NEW_VAL}\"" >> /tmp/config_uci_process.sh
#echo "${UCI_KEY}" >> /tmp/config_uci_process.sh


if [ "${UCI_CONFIG}" = "application" ] || [ "${UCI_CONFIG}" = "audioplex" ]; then
  if [ "${UCI_OLD_VAL}" != "${UCI_NEW_VAL}" ]; then
    echo "/var/run/audioplex-app.pid" > ${RESTART_APPS_DIR}/audioplex
  fi

  if [ "${UCI_SECTION}" = "rtp_out" ]; then
    exit 9
  fi
fi


# If "network.eth0.proto" is changed, reboot the device.
if [ "${UCI_CONFIG}" = "network" ] && [ "${UCI_SECTION}" = "eth0" ] && [ "${UCI_OPTION}" = "proto" ]; then
  if [ "${UCI_OLD_VAL}" != "${UCI_NEW_VAL}" ]; then
    exit 9
  fi
fi


if [ ${UCI_KEY} = "application.main_config.backend_url" ]; then
  /usr/bin/barix-restore-defaults.sh soft > /dev/null 2>&1
  uci set ${UCI_KEY}="${UCI_NEW_VAL}"
  uci commit
  # Direct reboot device
  /sbin/reboot
fi

