

// Application status tab onload function
function onloadAppStatusJs() {
}


function updateValueFromUci(uciName)   {
    let valueElem = document.getElementById("value-"+uciName);
    if (valueElem) {
        valueElem.innerText = _appStatusJson.appStatus[uciName];
        // console.log(uciName+"=", _appStatusJson.appStatus[uciName]);
    }
}


function refreshApplicationStatus()    {
    updateValueFromUci("application.main_config.backend_url");
    updateValueFromUci("application.main_config.active_url");
    updateValueFromUci("application.main_config.priority_url");
    updateValueFromUci("application.main_config.playback_url");
    updateValueFromUci("application.main_config.failover_url");
    updateValueFromUci("application.audio.player_volume_percent");
}

/**
 * Obtain a application status from UCIs using ajax. NOTE: this method is synchronous.
 */
const APP_UCI_ENDPOINT = "/app/cgi-bin/appStatus.cgi";
let _appStatusJson = null;

// console.log("app_status");

function updateAppStatus() {
    commonToolsReadJsonFile(APP_UCI_ENDPOINT + "?" + (new Date()).getTime(), false, function (content) {
        if (content) {
            try {
                const appStatusJson = JSON.parse(content);
                // Only do a status render if if fist time or data is different
                if (appStatusJson) {
                    _appStatusJson = appStatusJson;
                }
            } catch (e) {
                // console.log("appStatusJson PARSE ERROR");
            }
        } else {
            // console.log("appStatusJson has no content");
        }
    });
}

let updateAppStatusTimer = setInterval(updateAppStatus, 5000);
updateAppStatus();


let updateApplicationStatusTimer = setInterval(refreshApplicationStatus, 1000);
refreshApplicationStatus();
