
/**
 * ONLOAD script function
 * This function will be invoked by the loader
 */
function onloadAppSettingsJs()   {
    // Remove Hide common master volume
    commonToolsHideElemId("row-application.audio.volume");
    commonToolsHideElemId("row-device_alias");
    commonToolsHideElemId("row-syslogd.remote.ipaddr");
    commonToolsHideElemId("row-network.avahi.enabled");

    // Timer is needed to ensure that the DOM is updated
    // setTimeout(showSettingInOrderToPortalMode, 250);
    setTimeout(showSettingInOrderToRtpForward, 250);
}


/**
 * ONLOAD script function for HELP frame
 * This function will be invoked by the loader
 */
function onloadAppSettingsHelpJs()  {
    commonToolsHideElemId("help-avahi");
}


// function showSettingInOrderToPortalMode()   {
//     const applicationTypeElem = document.getElementById("application_type");
//     if (applicationTypeElem) {
//         visualizePlaylistSettings(applicationTypeElem.value);
//     }
// }


// function visualizePlaylistSettings(app_type)  {
//     if (app_type === "portal")   {
//         commonToolsHideElemId("row-application.main_config.failover_url");
//         commonToolsHideElemId("row-application.main_config.playback_url");
//         commonToolsHideElemId("row-application.audio.player_volume_percent");
//         commonToolsShowElemId("row-application.main_config.backend_url");
//         commonToolsHideElemId("row-network.sonic_ip.enabled");
//     } else {
//         commonToolsShowElemId("row-application.main_config.playback_url");
//         commonToolsShowElemId("row-application.main_config.failover_url");
//         commonToolsShowElemId("row-application.audio.player_volume_percent");
//         commonToolsHideElemId("row-application.main_config.backend_url");
//         commonToolsShowElemId("row-network.sonic_ip.enabled");
//         commonToolsUpdatePanelHeightForElem(document.getElementById("row-application.main_config.playback_url"));
//     }
// }


function showSettingInOrderToRtpForward()   {
    const applicationTypeElem = document.getElementById("rtp_forward_enable");
    if (applicationTypeElem) {
        visualizeRtpForward(applicationTypeElem.value);
    }
}

function visualizeRtpForward(value) {
    if (value === "true") {
        commonToolsShowElemId("row-audioplex.rtp_out.url");
        commonToolsShowElemId("row-audioplex.rtp_out.warn");
        commonToolsShowElemId("row-audioplex.rtp_out.audio_format");
        commonToolsUpdatePanelHeightForId("row-audioplex.rtp_out.enable");
    } else {
        commonToolsHideElemId("row-audioplex.rtp_out.url");
        commonToolsHideElemId("row-audioplex.rtp_out.warn");
        commonToolsHideElemId("row-audioplex.rtp_out.audio_format");
    }
}
