#!/bin/sh

DIAGNOSTICS="/var/log/diagnostics"

rm -rf $DIAGNOSTICS
mkdir $DIAGNOSTICS

env > $DIAGNOSTICS/environment.txt

uci show > $DIAGNOSTICS/uci_config.txt

tar czf $DIAGNOSTICS/conf.tar.gz -C /mnt/data conf

uptime > $DIAGNOSTICS/uptime.txt

top -b -n 5 > $DIAGNOSTICS/top_samples.txt

cp /proc/meminfo $DIAGNOSTICS/meminfo.txt

tar czf $DIAGNOSTICS/netstats.tar.gz -C /proc/net .

res=$(uci -q get application.main_config.backend_url)
if [ -n "$res" ]; then
    host=$(echo "$res" | sed -E 's~^(wss|ws)://([^/:]+).*~\2~')
    if [ -n "$host" ]; then
	ping -c 3 "$host" > $DIAGNOSTICS/ping_portal.txt
    else
        echo "Invalid Portal url format: $res" > $DIAGNOSTICS/ping_portal.txt
    fi
else
    echo "There is no Portal configured!" > $DIAGNOSTICS/ping_portal.txt
fi

res=$(uci -q get application.main_config.playback_url)
if [ -n "$res" ]; then
    host=$(echo "$res" | sed -E 's~^(https|http)://([^/:]+).*~\2~')
    if [ -n "$host" ]; then
        ping -c 3 "$host" > $DIAGNOSTICS/ping_playback_url.txt
    else
        echo "Invalid main url format: $res" > $DIAGNOSTICS/ping_playback_url.txt
    fi
else
    echo "There is no main url configured!" > $DIAGNOSTICS/ping_playback_url.txt
fi

cp /etc/resolv.conf $DIAGNOSTICS/resolv.conf

cp /etc/network/interfaces $DIAGNOSTICS/network_interfaces.txt

df -h > $DIAGNOSTICS/filesystem_usage.txt

nslookup 1.barix.pool.ntp.org > $DIAGNOSTICS/lookup_ntp.txt

nslookup release.barixupdate.com > $DIAGNOSTICS/lookup_downloads.txt

echo "NO_INFO" > $DIAGNOSTICS/factory_info
echo "NO_INFO" > $DIAGNOSTICS/factory_info.json

cp /tmp/factory_info_partition/factory_info $DIAGNOSTICS/factory_info
cp /tmp/factory_info_partition/factory_info_json $DIAGNOSTICS/factory_info.json

cp -R /mnt/data/conf/ $DIAGNOSTICS/conf

mkdir $DIAGNOSTICS/fallback_tracks
cp -R /mnt/data/fallback_tracks/conf/ $DIAGNOSTICS/fallback_tracks
ls -l /mnt/data/music > $DIAGNOSTICS/fallback_tracks/asset_list.txt

mkdir $DIAGNOSTICS/assets
cp -R /mnt/data/assets/conf/ $DIAGNOSTICS/assets
ls -l /mnt/data/assets/data > $DIAGNOSTICS/assets/asset_list.txt


tar vczf /lastlogs.tar.gz -C /var/log .
