# Barix Web UI 
# (c)2013 Barix AG
#
# Created 13.11.2014 by Aleksandar Simeonov
# Functions to clean up haserl instances

#DUMP_FILE=/var/run/.instance

function check_instances() 
{
	# declare local vars
	local PS_DUMP
	local OWN_PIDS
	local OTHER_PIDS
	local TOTAL_OWN_PIDS
	local TOTAL_OTHER_PIDS
	local i
	local TMP_INFO
        
        # init them separately, sometimes bash has issues with that
#       PS_DUMP=$(ps)                
        OWN_PIDS=$(ps | grep "haserl" | grep $1 | { while read -r first _; do printf '%s\n' "$first"; done; } | tr '\n' ' ')
        OTHER_PIDS=$(ps | grep "/usr/bin/haserl" | grep -v grep | grep -v $1 | { while read -r first _; do printf '%s\n' "$first"; done; } | tr '\n' ' ')
        TOTAL_OWN_PIDS=$(IFS=' '; set -- $OWN_PIDS; echo $#)                                                                                
        TOTAL_OTHER_PIDS=$(IFS=' '; set -- $OTHER_PIDS; echo $#)                                                                            
	
#	echo "Called by script: $1" >> $DUMP_FILE
#	echo "$PS_DUMP" >> $DUMP_FILE
#	echo "OWN_PIDS=$OWN_PIDS" >> $DUMP_FILE	
#	echo "TOTAL_OWN_PIDS=$TOTAL_OWN_PIDS" >> $DUMP_FILE
#	echo "OTHER_PIDS=$OTHER_PIDS" >> $DUMP_FILE
#	echo "TOTAL_OTHER_PIDS=$TOTAL_OTHER_PIDS" >> $DUMP_FILE
	
	# kill "alien" processes
	if [ "$TOTAL_OTHER_PIDS" -gt 0 ] ; then
		# stop them from spawning other processes
		kill -stop ${OTHER_PIDS}
		# kill irrelevant processes
#		echo "Killing alien processes ..." >> $DUMP_FILE
		for i in $OTHER_PIDS
		do 	
			TMP_INFO=$(ps | grep -v grep | grep $i)
#			echo "INFO for $i: $TMP_INFO" >> $DUMP_FILE
			killtree $i
		done
	fi
	# kill earlier instances of the same cgi file
	if [ "$TOTAL_OWN_PIDS" -gt 1 ] ; then
#		echo "Killing extra proceses with same name" >> $DUMP_FILE
		# select all but the last one, it must be ours
		OWN_PIDS_NO_LAST=$(echo $OWN_PIDS | sed s/'\w*$'// )
		for i in $OWN_PIDS_NO_LAST
		do
			TMP_INFO=$(ps | grep -v grep | grep $i)                                                                                   
			echo "INFO for $i: $TMP_INFO" >> $DUMP_FILE                                                                               
#			killtree $i
		done		
	fi
}

function killtree()
{
	# get the related processes
	local PS_TREE=$(ps -o pid,pgid | grep $1 | { while read -r first _; do printf '%s\n' "$first"; done; } | tr '\n' ' ')
#	echo "Killing tree belonging to $1: $PS_TREE" >> $DUMP_FILE
	kill -9 ${PS_TREE}
}
