import alsaaudio
import logging
import os
import shlex
import subprocess
import time

from barix import HTTPRequestsAPI

from .constants import *

log = logging.getLogger('flask-backend')


'''
Reads the file RESTART_SERVICES_FILE_PATH containing a list of services to restart and restarts them by order of priority.
The list should contain one string per line and the function is going to iterate by each line until there is no more lines to read.
When a service string is restarted, it is removed from the list. After each iteration, the list is rewritten in the file.
If there is a string "reboot" in the file, the device reboots and the loop is finished without reading any other line, because when the device reboots, all services will be restarted by order and RESTART_SERVICES_FILE_PATH is removed, since it is stored in /tmp. 
Then checks if the backend needs to restart. When the backends is launched, it will check the list again to see if there are services left to restart.
After that, it will sort the services by priority (each service has a SXX prefix: check /etc/rc5.d) and restart them one by one.
'''
def restartServicesFromFile():
    #global readyState
    # check if file already exists
    if os.path.isfile(RESTART_SERVICES_FILE_PATH):
        finished = False
        while not finished:
            try:
                proc = None
                # read services from file
                servicesList = readFromRestartServicesFile()
                if len(servicesList) > 0:
                    log.info('List of services to restart: {}'.format(servicesList))
                    if "reboot" in servicesList:
                        cmd = "/sbin/reboot"
                        log.info("Executing: {}".format(cmd))
                        proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        proc.wait()
                        finished = True
                    elif "icmaster_webui" in servicesList:
                        servicesList.remove("icmaster_webui")
                        # delete service from file
                        writeIntoRestartServicesFile(servicesList)
                        cmd = "/etc/init.d/icpaging-master restart_webui"
                        log.info("Executing: {}".format(cmd))
                        proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        proc.wait()
                    elif "eaton_webui" in servicesList:
                        servicesList.remove("eaton_webui")
                        # delete service from file
                        writeIntoRestartServicesFile(servicesList)
                        cmd = "/barix/hooks/application/webui restart"
                        log.info("Executing: {}".format(cmd))
                        proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        proc.wait()
                    elif "backend_flask" in servicesList:
                        servicesList.remove("backend_flask")
                        # delete service from file
                        writeIntoRestartServicesFile(servicesList)
                        cmd = "barix-wd --pid-file=/var/run/webui.pid --restart"
                        log.info("Executing: {}".format(cmd))
                        proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        proc.wait()
                    else:
                        # restart services by order
                        sortedServicesList = sorted(servicesList)
                        # log.debug('Sorted list of services to restart: {}'.format(sortedServicesList))
                        service = sortedServicesList.pop(0)
                        if service == "epic.main.volume" or service == "application.audio.volume":
                            vol = None
                            from .uci import getValueOfUci
                            if service == "epic.main.volume":
                                vol = getValueOfUci("epic", "main", "volume")
                            if service == "application.audio.volume":
                                vol = getValueOfUci("application", "audio", "volume")
                            mixer = "Line Out"
                            try:
                                f = open("/etc/barix/soundcard.conf", 'r')
                                lines = f.read().split('\n')
                                for line in lines:
                                    if line.startswith('master.control'):
                                        mixer = ((line.split('='))[1]).strip('\n')
                                f.close()
                            except Exception as e:
                                log.error("An error occurred while getting mixer: {}. Going to use mixer {}.".format(e, mixer))
                            #cmd = "/usr/bin/amixer -q -c 0 set '" + mixer + "' " + vol + "%"
                            #log.info("Executing: {}".format(cmd))
                            #proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            mainVolumeCtl = alsaaudio.Mixer(mixer) # mixer = "BARIX_MAIN"
                            mainVolumeCtl.setvolume(int(vol))
                        elif service == "ipac_main_app":
                            cmd = "barix-wd --pid-file=/var/run/ipac-app.pid --restart"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        elif service == "ussi-controller":
                            cmd = "/barix/hooks/application/ussi-controller.hook stop"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            cmd = "/barix/hooks/application/ussi-controller.hook start"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        elif service == "icmaster_main_app":
                            cmd = "/etc/init.d/icpaging-master restart"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        elif service == "ae_main_app":
                            cmd = "barix-wd --pid-file=/var/run/msx00-app.pid --restart"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        elif service == "alarm_shuttle_main_app":
                            cmd = "/etc/init.d/alarm-shuttle restart"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        elif service == "dropbear":
                            #cmd = "barix-wd --pid-file=/var/run/dropbear.pid --restart"
                            cmd = "/barix/hooks/application/dropbear.hook stop"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            proc.wait()
                            cmd = "/barix/hooks/application/dropbear.hook start"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                        elif service == "S20timezone-handler":
                            cmd = "/etc/rc5.d/S20timezone-handler restart"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)
                            proc.wait()
                            time.tzset()
                        else:
                            path = "/etc/rc5.d/"
                            cmd = path + service + " restart"
                            log.info("Executing: {}".format(cmd))
                            proc = subprocess.Popen(shlex.split(cmd), shell=False)

                        # delete service from file
                        writeIntoRestartServicesFile(sortedServicesList)
                        finished = True
                        if proc is not None:
                            proc.wait()
                            log.info(proc.stdout)
                            if proc.returncode != 0:
                                log.error("Error trying to restart service {}:{}".format(service, proc.returncode))
                            else:
                                log.debug("Service {} restarted with success.".format(service))
                else:
                    log.info("No services to restart: file {} is empty".format(RESTART_SERVICES_FILE_PATH))
                    finished = True
            except Exception as e:
                log.error("An error occurred while restarting services: {}".format(e))
                finished = True
                raise e
            time.sleep(1)
    else:
        log.info("No services to restart: file {} does not exist".format(RESTART_SERVICES_FILE_PATH))


'''
Reads the file RESTART_SERVICES_FILE_PATH containing a list of services to restart.
Returns an empty list if the file doesn't exist or a list with the content of the file, where each element corresponds to a line of the file.
'''
def readFromRestartServicesFile():
    try:
        servicesFromFile = []
        if os.path.isfile(RESTART_SERVICES_FILE_PATH):
            f = open(RESTART_SERVICES_FILE_PATH, 'r')
            content = f.readlines()
            for elem in content:
                servicesFromFile.append(elem.strip('\n'))
            # log.debug('file contents {}'.format(content))
            # if content != '':
            # servicesFromFile = ast.literal_eval(content)
    except Exception as e:
        log.error("An error occured while reading from file {}:{}".format(RESTART_SERVICES_FILE_PATH,e))
        raise e
    else:
        return servicesFromFile


'''
Writes the provided list of services to restart to the RESTART_SERVICES_FILE_PATH file.
@param listOfServices: list of services to restart
Each list element will correspond to a line in the file. Lines are separated by \n character.
'''
def writeIntoRestartServicesFile(listOfServices):
    try:
        strListOfServices = ""
        for service in listOfServices:
            strListOfServices = strListOfServices + service + "\n"
        #log.debug(strListOfServices)
        strListOfServices = strListOfServices[:-1] #remove last \n
        log.debug("Writting into file {}: {}".format(RESTART_SERVICES_FILE_PATH, strListOfServices))
        f = open(RESTART_SERVICES_FILE_PATH, 'w')
        f.write(strListOfServices)
        f.close()
    except Exception as e:
        log.error("Error writing into {}:{}".format(RESTART_SERVICES_FILE_PATH, e))
        raise e
