import logging
import os
import uuid

from .uci import getValueOfUci

from .constants import *

log = logging.getLogger('flask-backend')

'''
Generate a new session key
Session Key is used to validate logins.
A unique ID is generated and stored in the file SESSION_KEY_FILE_PATH.
'''
def generateNewSessionKey():
    sessionKey = uuid.uuid4().hex
    try:
        f = open(SESSION_KEY_FILE_PATH, 'w')
        f.write(sessionKey)
        f.close()
        return sessionKey
    except Exception as e:
        log.error("Error while writing in file {}: {}".format(SESSION_KEY_FILE_PATH, e))
        raise e


'''
Get the session key
Session Key is used to validate logins.
Reads the file SESSION_KEY_FILE_PATH, which is where the session key is stored.
If the file doesn't exist or if it is empty, generates a new session key.
Returns the session key (string).
'''
def getSessionKey():
    try:
        # if file does not exist, create it
        if not os.path.isfile(SESSION_KEY_FILE_PATH):
            sessionKey = generateNewSessionKey()
        else: # file exists
            f = open(SESSION_KEY_FILE_PATH, 'r')
            sessionKey = f.read()
            if sessionKey == '': # file is empty
                sessionKey = generateNewSessionKey()
        return sessionKey
    except Exception as e:
        raise e


from functools import wraps
from flask import session, Response

'''
Check if login is required and, if so, if user is logged in.
If login is not required or if it is required and the user is already logged in, allows to proceed. Otherwise, a Non Authorized 401 HTTP Response is returned.
To check if the user is logged in, compared the sessionID from the request to the sessionID stored. If none is provided in the request or if they don't match, then login is invalid. 
'''
def login_required(f):
    @wraps(f)
    def decorated_function(*args, **kwargs):
        try:
            login_uci = getValueOfUci('httpd', 'webserver', 'password_set')
        except Exception:
            return Response(status=500)
        else:
            try:
                if login_uci == 'true':
                    if 'sessionID' not in session:
                        return Response("Login required", status=401, headers={"Content-Type": "text/plain"})
                    if session['sessionID'] != getSessionKey():
                        return Response("Login required", status=401, headers={"Content-Type": "text/plain"})
                    else:
                        return f(*args, **kwargs)
                else:
                    return f(*args, **kwargs)
            except Exception as e:
                log.error("Error while logging: {}".format(e))
                return Response(status=500)
    return decorated_function