

class Led:
    LED_ON = '255'
    LED_OFF = '0'

    def __init__(self, ledName: str):
        self.ledPaths = {
            'brightness': '/sys/class/leds/' + ledName + '/brightness',
            'trigger'   : '/sys/class/leds/' + ledName + '/trigger',
            'delay_on'  : '/sys/class/leds/' + ledName + '/delay_on',
            'delay_off' : '/sys/class/leds/' + ledName + '/delay_off'
        }

    def __setValue(self, path:str, value:str) -> None:
        try:
            with open(path, 'w') as f:
                f.write(str(value))
        except OSError as e:
            print('Error setting LEDS path {} to value {}: {}'.format(path, value, e))

    def setBrigtness(self,level:float) -> None:
        intLv   = int(level*255)
        if intLv<0:
            intLv   = 0
        elif intLv>255:
            intLv   = 255
            
        self.__setValue(self.ledPaths['brightness'],str(intLv))
        
    def set(self,on:bool) -> None:
        if on:
            self.setBrigtness(1.0)
        else:
            self.setBrigtness(0)
        


