
class Led:
    '''
    Module to implement the led operations. It supports
    the functions Red, Green, Yellow and Off. Every collor
    could also be set to blink.
    '''
    LED_ON = '255'
    LED_OFF = '0'

    def __init__(self, redDev, greenDev):
        self.ledPaths = {'red': {
            'brightness': redDev + '/brightness',
            'trigger': redDev + '/trigger',
            'delay_on': redDev + '/delay_on',
            'delay_off': redDev + '/delay_off'
            },
                        'green': {
            'brightness': greenDev + '/brightness',
            'trigger': greenDev + '/trigger',
            'delay_on': greenDev + '/delay_on',
            'delay_off': greenDev + '/delay_off'
            }
                        }

    def setValue(self, path, value):
        try:
            with open(path, 'w') as f:
                f.write(str(value))
        except OSError as e:
            print('Error setting LEDS path {} to value {}: {}'.format(path, value, e))

    def __setBlink(self, ledPath, blink, timeOn=None, timeOff=None):
        trigger = 'none'
        if blink:
            trigger = 'timer'
        self.setValue(ledPath['trigger'], trigger)
        if timeOn is not None:
            self.setValue(ledPath['delay_on'], timeOn)
        if timeOff is not None:
            self.setValue(ledPath['delay_off'], timeOff)

    def setRed(self, blink=False, blinkTime=None):
        self.__setBlink(self.ledPaths['red'], blink, blinkTime, blinkTime)
        self.setValue(self.ledPaths['red']['brightness'], self.LED_ON)
        self.setValue(self.ledPaths['green']['brightness'], self.LED_OFF)

    def setGreen(self, blink=False, blinkTime=None):
        self.__setBlink(self.ledPaths['green'], blink, blinkTime, blinkTime)
        self.setValue(self.ledPaths['red']['brightness'], self.LED_OFF)
        self.setValue(self.ledPaths['green']['brightness'], self.LED_ON)

    def setYellow(self, blink=False, blinkTime=None):
        self.__setBlink(self.ledPaths['red'], blink, blinkTime)
        self.__setBlink(self.ledPaths['green'], blink, blinkTime)
        self.setValue(self.ledPaths['red']['brightness'], self.LED_ON)
        self.setValue(self.ledPaths['green']['brightness'], self.LED_ON)

    def setOff(self):
        self.__setBlink(self.ledPaths['red'], False)
        self.__setBlink(self.ledPaths['green'], False)
        self.setValue(self.ledPaths['red']['brightness'], self.LED_OFF)
        self.setValue(self.ledPaths['green']['brightness'], self.LED_OFF)


class Led1(Led):
    def __init__(self):
        Led.__init__(self, '/sys/class/leds/barix:led1:red', '/sys/class/leds/barix:led1:green')

class Led2(Led):
    def __init__(self):
        Led.__init__(self, '/sys/class/leds/barix:led2:red', '/sys/class/leds/barix:led2:green')
