#!/bin/sh

ALSA_INT=$(cat /etc/barix/soundcard.conf | grep "master.device" | sed -e 's/master.device\s*=\s*//')
if [ -z "$ALSA_INT" ]; then
    ALSA_INT="default"
fi

echo "$0: ALSA interface is ALSA_INT=$ALSA_INT"
echo "$0: Starting /usr/bin/speaker-test -D"$ALSA_INT" -f1000 -tsine -c1  -l0 >/dev/null 2>/dev/null"

if board-probe s400 || board-probe sp400; then
    s400-minijack enable
elif board-probe m400; then
    m400-amp enable
    m400-rca out
elif board-probe mpi400; then
    mpi400-audio enable
elif board-probe tpa400; then
    tpa400-audio enable
else
    echo 1 > /sys/class/gpio/gpio17/value
fi

while true; do
    /usr/bin/speaker-test -D"$ALSA_INT" -f1000 -tsine -c1 -l0 >/dev/null 2>/dev/null
done

