#!/bin/sh
# Barix configuration interface
# (c)2012 Barix AG
#
# generates configuration file for the network subsystem /etc/init.d/network
# templates: /barix/config/templates/templates/network.interfaces
# destination: /etc/network/interfaces

# include configuration interface functions
. /lib/config/functions.sh

TEMPLATES_PREFIX=/barix/config/templates
TEMPLATE_DIR=${TEMPLATES_PREFIX}/templates


# check parameters
if [ $# -lt 1 ] ; then
	echo "Barix configuration interface"
	echo "Generates configuration file for the given subsystem out of the system UCI configuration."
	echo "Usage: $0 <subsystem>"
	echo "Example /lib/config/gen_config.sh network"
	exit 1
fi

# compose config file and include it
SUBSYSTEM="$1"
CONFIG_FILE="${TEMPLATES_PREFIX}/${SUBSYSTEM}"
. "$CONFIG_FILE"


function disclaimer_hash()
{
	if [ "X$template_file" != "X" ] ; then 
		templ="$TEMPLATE_DIR/$template_file"
	else
		templ="<none>"
	fi
	echo "# Barix configuration interface
# Subsystem: $SUBSYSTEM 
# Configuration file: $CONFIG_FILE
# Template: $templ
#
# DO NOT EDIT THIS FILE! THIS FILE IS AUTOMATICALLY GENERATED.
#
# This file is automatically generated by the configuration system
# /lib/config/gen_config.sh . For changes edit $CONFIG_FILE
#"

}

function disclaimer_xml()
{
	if [ "X$template_file" != "X" ] ; then 
		templ="$TEMPLATE_DIR/$template_file"
	else
		templ="<none>"
	fi
	echo "
<!--
Barix configuration interface
Subsystem: $SUBSYSTEM 
Configuration file: $CONFIG_FILE
Template: $templ

DO NOT EDIT THIS FILE! THIS FILE IS AUTOMATICALLY GENERATED.

This file is automatically generated by the configuration system
/lib/config/gen_config.sh . For changes edit $CONFIG_FILE

-->
"

}

if [ "$DST_FILE"X = "X" ] ; then 
	echo "Error: no destination file defined in $CONFIG_FILE. Exiting."
	exit 1; 
fi


# generate all destination files
for (( i=0; i<${#DST_FILE[*]}; i++ ))
do

	dst_file="${DST_FILE[$i]}"
	comment_prefix="${COMMENT_PREFIX[$i]}"
	template_file="${TEMPLATE_FILE[$i]}"
	dynamic_content_fn="${DYNAMIC_CONTENT_FN[$i]}"


	# clear the destination file
	>"$dst_file"

	# print disclaimer
	case "$comment_prefix" in
		"#") disclaimer_hash >> "$dst_file";;	# disclaimer using bash like comments
		"xml") disclaimer_xml >> "$dst_file";;	# disclaimer using xml comments
		*);;					# no disclaimer
	esac

	# first copy template, if defined
	if [ "$template_file"X != "X" ] ; then 
		cat "$TEMPLATE_DIR/$template_file" >> "$dst_file"
	fi

	# then add dynamic parameters, if the function exists
	if declare -f "$dynamic_content_fn" > /dev/null ; then
		$dynamic_content_fn >> "$dst_file"
	else
		echo "Error: function for generating dynamic content is not defined. Exiting."
		exit 1
	fi

done

# that's all folks!
exit $?
