import snmp_passpersist as snmp
import time
from barix.web import uci

global flexaAppName
global flexaRegId
global flexaServiceUrl
global flexaServiceEnabled

flexaAppName = uci.getValueOfUci('flexa_agent', 'service', 'appl_name')
if flexaAppName == "" or flexaAppName == None:
	flexaAppName = "No Flexa App Installed!"
flexaAppVersion =  uci.getValueOfUci('flexa_agent', 'service', 'package_version')
if flexaAppVersion == "" or flexaAppVersion == None:
	flexaAppVersion = "undefined"
flexaRegId = uci.getValueOfUci('flexa_agent', 'registry', 'regid')
if flexaRegId == "" or flexaRegId == None:
	flexaRegId = "Invalid RegId or not a Barix Flexa device!"
flexaServiceUrl = uci.getValueOfUci('flexa_agent', 'registry', "registry_url")
flexaServiceEnabled = "Enabled" if uci.getValueOfUci('flexa_agent', 'service', "enabled") == "true" else "Disabled"

def update():
	pp.add_str('1.1',flexaAppName)
	pp.add_str('1.2',flexaAppVersion)
	pp.add_str('1.3',flexaRegId)
	pp.add_str('1.4',flexaServiceUrl)
	pp.add_str('1.5',flexaServiceEnabled)

pp = snmp.PassPersist(".1.3.6.1.4.1.17491.1.159")

pp.start(update, 30)

def main():
	while True:
		time.sleep(2)

if __name__ == "__main__":
	main()

