var localNavMenuWidth=parseInt(0,10); 	// force numeric type

function resizeFrame(frameId){
	var frame;
	frame = document.getElementById(frameId);
	innerDoc = (frame.contentDocument) ? frame.contentDocument : frame.contentWindow.document;
	if (innerDoc == null){
		// Google Chrome
	      	frame.height = document.all[frameId].clientHeight + document.all[frameId].offsetHeight + document.all[frameId].offsetTop;
	      	frame.width = document.all[frameId].clientWidth + document.all[frameId].offsetWidth + document.all[frameId].offsetLeft;
		calcHrWidth(frame.width);
	}else{
		frameToResize = (frame.style) ? frame.style : frame;
	  	frameToResize.height = innerDoc.body.scrollHeight + 18;
		frameToResize.width = innerDoc.body.scrollWidth + 18;
		calcHrWidth(frameToResize.width);
	}
}

function calcHrWidth(newValue){
	// Adapts the separator line width 
	newValue = newValue.substring(0,newValue.indexOf('px'));
	if (newValue > localNavMenuWidth){localNavMenuWidth=newValue+"px";}
}

function resizeSeparators(){
	 document.getElementById('app_status_separator').style.width=localNavMenuWidth;
	 document.getElementById('app_config_separator').style.width=localNavMenuWidth;
}

function getFrameText(iframe_name){
	var iframe_body, iframe_window, iframe_text_range, iframe_text_sel;
	var tmp;
	
	if (iframe_name==''){
		iframe_body=window.document.getElementsByTagName("body")[0];
	}else{
		iframe_window = window.frames[iframe_name];
		iframe_body = iframe_window.document.getElementsByTagName("body")[0];
	}

	if (iframe_body.createTextRange) {
		// IExplorer
      	iframe_text_range = iframe_body.createTextRange();
        	iframe_text_range.moveToElementText(iframe_body);
      	iframe_text_range.select();
      	iframe_text_sel=document.selection;
    	} else if (document.createRange && window.getSelection) {
    		// other browsers
     		//}
            iframe_text_range = document.createRange();
        	iframe_text_range.selectNodeContents(iframe_body);
            
        	// Safari returns Selection object with null
           
        	// anchorNode, so, handle this case here

        	tmp=window.getSelection();
        	if (window.getSelection.anchorNode){
                
        		// Opera, Firefox, Chrome
                
        		iframe_text_sel = window.getSelection();
        	}else{
                
        		if (iframe_name==''){
        			// all browsers, main frame
        			iframe_text_sel = window.getSelection();
        		}else{
        			// Safari method to get the iframe contents
  
        			iframe_text_sel = document.getElementById(iframe_name).contentWindow.getSelection();
        		}
        	}
        	iframe_text_sel.removeAllRanges();
        	iframe_text_sel.addRange(iframe_text_range);
	}
	return iframe_text_sel;
}

function get_para_value(el){
    return el.textContent || el.innerText || '';
}

function exportToText(){
	var text_area_elem;
	var section_separator='\r-----------------------------------------------------------------\r';
	var app_cfg_para=app_name+' Configuration';
	var app_status_para=app_name+' Status';
	var text_window = window.open('', 'PlainText','width=200,height=400');
	var total_txt,common_txt,status_txt,config_txt;
	var lowcase,lowcase_pos;
	
	// get the status that is common for all ABCL applications
	common_txt=getFrameText('').toString(); 
	lowcase=common_txt.toLowerCase();
	lowcase_pos=lowcase.search(app_status_para.toLowerCase());
	common_txt=common_txt.substring(0,lowcase_pos);
	
	// copy the frame contents and create the content for the textbox
	status_txt=app_status_para.toUpperCase() + getFrameText(status_frame).toString();
	config_txt=app_cfg_para.toUpperCase() + getFrameText(config_frame).toString();
	total_txt=common_txt+section_separator+status_txt+section_separator+config_txt;

	// create the html page on the fly
	text_window.document.write('<html><head><body><form name=txt_form>');
	text_window.document.write('<textarea cols=80 rows=60 id=plain_txt></textarea>');
	text_window.document.write('</form></body></head></html>');
	
	// finally, paste all the text in the textbox
	text_area_elem=text_window.document.txt_form.plain_txt;
	text_area_elem.value=total_txt;
	text_window.document.close();
}
