#!/bin/sh
#
#   Build a html page with the content of license-report.csv
#

CSV_FILE="/barix/info/licenses-report.csv"
HTML_FILE="/usr/local/www/current/open-source-licenses.html"

# -----------------------------------------------------------------------------

VERSION=$(cat /barix/info/VERSION)

# HTML Header
echo '
<head>
    <title>RetailPlayer '$VERSION' - Open Source Licenses</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css" rel="stylesheet" type="text/css">
    <meta name="theme-color" content="#000000">
    <!-- FAVICON related -->
    <link rel="apple-touch-icon" sizes="180x180" href="/theme/favicon/apple-touch-icon.png?v='$VERSION'">
    <link rel="icon" type="image/png" sizes="32x32" href="/theme/favicon/favicon-32x32.png?v='$VERSION'">
    <link rel="icon" type="image/png" sizes="16x16" href="/theme/favicon/favicon-16x16.png?v='$VERSION'">
   <link rel="manifest" href="/theme/favicon/site.webmanifest?v='$VERSION'">
    <link rel="mask-icon" href="/theme/favicon/safari-pinned-tab.svg?v='$VERSION'" color="#6F6F6F">
    <meta name="msapplication-TileColor" content="#6F6F6F">
    <meta name="theme-color" content="#FFFFFF">
    <meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate">
    <meta http-equiv="Pragma" content="no-cache">
    <meta http-equiv="Expires" content="0">

   <style>
        table.license   {
            border-collapse: collapse;
            color: #444444;
        }

        table.license th, table.license td  {
            border: solid 1px #CCCCCC;
        }
    </style>

</head>
<body class="main-menu" onload="onLoadScriptsAndFunctions()">
    <table class="main-menu" cellpadding="0" cellspacing="0">

        <tr id="navbar" class="main-menu">
            <th class="main-menu">
                <ul id="main-menu" class="main-menu">
                </ul>
            </th>
            <th id="end_navbar" class="main-menu main-menu-contrast main-menu-hdwr-info">

            </th>
        </tr>

        <tr>
            <td id="app_name_span" class="product">
                RetailPlayer '$VERSION' - Open Source Licenses
            </td>
            <td align="right" style="padding-right: 8px;">
                <a href="https://www.barix.com" target="_blank">
                    <img src="/theme/images/brand.png?v=6.3.0">
                </a>
            </td>
        </tr>

        <tr class="navbar-separator">
            <td id="navbar_separator" class="main-menu"</td>
            <td class="main-menu-contrast"></td>
        </tr>
    </table>
' > $HTML_FILE

# TODO: escape html entities

echo "<div style=\"text-align: center; margin: 32px 0;\">" >> $HTML_FILE
echo "<table class=\"license\" cellpadding=\"2px\" align=\"center\"><tbody>" >> $HTML_FILE

FIRST_LINE_IS_HEADER=false
ESCAPE_FIST_LINE=true

# Table header
echo "<tr>" >> $HTML_FILE
echo -n "<th>Package</th>" >> $HTML_FILE
echo -n "<th>Version</th>" >> $HTML_FILE
echo -n "<th>License</th>" >> $HTML_FILE
echo -n "</tr>" >> $HTML_FILE

# Table body
while IFS=, read -r PACKAGE VERSION LICENSE; do
    TAG="td";

    if [ "$ESCAPE_FIST_LINE" = "true" ]; then
        FIRST_LINE_IS_HEADER=false
        ESCAPE_FIST_LINE=false
        continue
    fi

    if [ "$FIRST_LINE_IS_HEADER" = "true" ]; then
        TAG="th"
        FIRST_LINE_IS_HEADER=false
    fi

    if [ "${LICENSE:1:-1}" != "CLOSED" ]; then
        # echo "${LICENSE:1:-1}";
        echo "<tr>" >> $HTML_FILE
        echo -n "<${TAG}>${PACKAGE:1:-1}</${TAG}>" >> $HTML_FILE
        echo -n "<${TAG}>${VERSION:1:-1}</${TAG}>" >> $HTML_FILE
        echo -n "<${TAG}>${LICENSE:1:-1}</${TAG}>" >> $HTML_FILE
        echo -n "</tr>" >> $HTML_FILE
    fi

done < ${CSV_FILE}

echo "</tbody></table>"  >> $HTML_FILE
echo "</div>" >> $HTML_FILE
echo "</body>"  >> $HTML_FILE

exit 0
