#!/usr/bin/python3

from subprocess import Popen, PIPE
import json
import sys

def getLicObj(name, status, identifier, issue_date, expire_date, features, validFlag):
    return {"name":name, "status":status, "identifier":identifier, "issue_date":issue_date, "expire_date":expire_date, "features":features, "validFlag": validFlag}

def  isLicenseValid(name):
    cmd = "/usr/bin/qiba-check-license " + name + " >> /dev/null 2>&1"
    process = Popen(cmd, shell=True)
    exit_code = process.wait()
    if exit_code == 0:
        return "Valid"
    else:
        return "Invalid"

def getLics():
    licList = []
    try:
        process = Popen("qiba-spi-get-info", stdout=PIPE)
        (output, err) = process.communicate()
        exit_code = process.wait()
        if exit_code != 0:
            raise
        spiInfo = json.loads(output)
        lics = spiInfo["SW_LICENSES"] 
        for lic in lics:
            try:
                name = lic["Image_Name"]
                status = lic["Status"]
                identifier = lic["License_ID"]
                issue_date = lic["Issue_Date"]
                expire_date = lic["Expire_Date"]
                features  = lic["Image_Features"]
                validFlag = isLicenseValid(lic["Image_Name"])
                licList.append(getLicObj(name, status, identifier, issue_date, expire_date, features, validFlag))
            except:
                continue
    except:
        raise
    return licList 

def printJsonLics():
    try:
        lics = getLics()
        sys.stdout.write(json.dumps(lics))
    except:
        sys.stdout.write("[]")

# main
printJsonLics()
