#!/bin/bash
. /usr/local/lib/cgi/status.sh
. /usr/local/lib/cgi/config.sh

#
# This script will be called whenever a form is submitted.
# Parameters:
#   1 - Name of changed UCI variable
#   2 - Old UCI value
#   3 - New UCI value
#
# Stdout will show as WebUI waiting messages.
#
# Exit status:
#   0 - Configuration applied normally.
#   1 - Configuration applied. Service need to be restarted.
#   2 - Configuration applied. Service need to be restarted. Http protocol or host changed.
#   9 - Configuration applied. Reboot needed.

UCI_KEY="${1}"
UCI_OLD_VAL="${2}"
UCI_NEW_VAL="${3}"

# DEBUG
#echo "${UCI_KEY} = \"${UCI_OLD_VAL}\" -> \"${UCI_NEW_VAL}\"" >> /tmp/config_uci.log
#echo "${UCI_KEY}" >> /tmp/config_uci_process.sh

# Print the string of the already configured WebUI protocol
function printProtocol() {
  echo -n "$(cfg_print_param httpd.webserver.protocol)://";
}


# print new URL of the refresh page
# call only if address is known (see the above function)
function printHost() {
  if cfg_string_compare network.eth0.proto "dhcp" ; then
    print_ip_addr
  else
    cfg_print_param network.eth0.ipaddr
  fi
}


if [ ${UCI_KEY} = "network.eth0.proto" ] && [ ${UCI_NEW_VAL} == "dhcp" ]; then
  echo "The device will get a new DHCP address. Enter the new address into the browser."
  exit 2;
fi

if [ ${UCI_KEY} = "network.eth0.proto" ] || [ ${UCI_KEY} == "network.eth0.ipaddr" ] || [ ${UCI_KEY} == "httpd.webserver.port" ]; then
  echo "Changing host address..."
  exit 2;
fi

if [ ${UCI_KEY} = "httpd.webserver.protocol" ]; then
  echo "Changing protocol to \"${UCI_NEW_VAL}\" on URL address. Please wait a second and click <a href=\"$(printProtocol)$(printHost)/\" target=\"_top\" style=\"color: #719ABE; text-decoration: none;\">here</a>."
  exit 2;
fi

if [[ ${UCI_KEY} == "proxy_config."* ]]; then
  echo "Rebooting device to configure proxy ..."
  exit 9;
fi

# Only if network.wlan0 is defined (device has wireless UCI)
if [[ ! -z `uci -q show network.wlan0` ]] && [[ ${UCI_KEY} == "network.wlan0."* ]]; then
  echo "Rebooting device to configure wireless..."
  exit 9;
fi

if [[ ${UCI_KEY} == "network."* ]] || [[ ${UCI_KEY} == "httpd."* ]]; then
  echo "Restarting services..."
  exit 1;
fi

if [[ ${UCI_KEY} == "dropbear.RunCtl.enable" ]]; then
  if [[ ${UCI_NEW_VAL} == "1" ]]; then
    /barix/hooks/application/dropbear start > /dev/null 2>&1
  else
    /barix/hooks/application/dropbear stop > /dev/null 2>&1
  fi
  exit 0
fi

if [ ${UCI_KEY} == "flexa_agent.service.enabled" ] && [ ${UCI_NEW_VAL} == "true" ]; then
  flexa-agent full > /dev/null 2>&1 &
  exit 0;
fi
