const MAX_N_USERS = 3;
let n_users = 0;
const ACCESS_OPTIONS = {
    "Read only": "ro",
    "Read/write": "rw"
};
const AUTH_TYPE_OPTIONS = {
    "MD5": "MD5",
    "SHA": "SHA"
}
const ENC_TYPE_OPTIONS = {
    "DES": "DES",
    "AES": "AES"
}
const SECURITY_LEVEL_OPTIONS = {
    "No auth": "noauth",
    "Auth": "auth",
    "Priv": "priv"
}

function goToHelpId(helpId)  {
    top.frames[1][1].location.href = "/cgi-bin/snmp_help.cgi#" + helpId;
}

function updateInputsList(input) {
    // get current input list
    const barionet_inputs_element = document.getElementById("snmp_traps_barionet_inputs");
    if (barionet_inputs_element) {
        let current_input_list = [];
        if (barionet_inputs_element.value !== "") {
            current_input_list = barionet_inputs_element.value.split(" ");
        }
        // check if should add input to list or remove it from list
        const index = current_input_list.indexOf(input.toString());
        if (index > -1) { // input exists in list
            current_input_list.splice(index, 1); // remove it from list
        } else {
            current_input_list.push(input.toString());
        }
        // store list again
        const list_to_store = current_input_list.join(" ");
        barionet_inputs_element.value = list_to_store;
    }
}

function updateTrapsDestinations() {
    const traps_destinations_element = document.getElementById("snmp_traps_destinations");
    if (traps_destinations_element) {
        let current_destinations_list = [];
        const primary_receiver_element = document.getElementById("primary_trap_receiver");
        const secondary_receiver_element = document.getElementById("secondary_trap_receiver");
        if ( (!primary_receiver_element && secondary_receiver_element) || (primary_receiver_element.value === "" && secondary_receiver_element.value !== "") ){
            notify.notify({message:'To set a Secondary Trap Receiver you must first set a Primary one!', level:'danger'});
            return false;
        }
        if (primary_receiver_element) {
            current_destinations_list.push(primary_receiver_element.value);
        }
        if (secondary_receiver_element) {
            current_destinations_list.push(secondary_receiver_element.value);
        }
        // store list to submit
        const list_to_store = current_destinations_list.join(" ");
        traps_destinations_element.value = list_to_store;
    }
    return true;
}

function snmpVersionChanged() {
    const selector_ver_element = document.getElementById("snmp_version");

    if (selector_ver_element) {

        // if protocol version is 1 or 2c
        if (selector_ver_element.value === "1" || selector_ver_element.value === "2c") {

            // show community
            const community_element = document.getElementById("row-snmp.traps.community");
            if (community_element) {
                community_element.style.display = "";
            }

            // hide users
            const users_section = document.getElementById("users-section");
            if (users_section) {
                users_section.style.display = "none";
            }

            // add empty value to remove uci
            const htmlElem = document.getElementById("snmp_user");
            htmlElem.removeAttribute("required");
            if (htmlElem) {
                htmlElem.value = "";
            }

            // hide snpm_user
            const snmpTrapsUserTrHtmlElem = document.getElementById("row-snmp.traps.user");
            if (snmpTrapsUserTrHtmlElem) {
                snmpTrapsUserTrHtmlElem.style.display = "none";
            }
        }

        // if protocol version is 3
        if (selector_ver_element.value === "3") {
            const community_element = document.getElementById("row-snmp.traps.community");

            // hide community
            if (community_element) {
                community_element.style.display = "none";
            }
            const community_input = document.getElementById("community");

            // add empty value to remove uci
            community_input.value = "";

            // if last user selected doesn't exist, set snmp.traps.user selector value to empty
            const snmpTrapsUserHtmlElem = document.getElementById("snmp_user");
            if (snmpTrapsUserHtmlElem) {

                const snmpUser1HtmlElem = document.getElementById("div-user1");
                const snmpUser2HtmlElem = document.getElementById("div-user2");
                const snmpUser3HtmlElem = document.getElementById("div-user3");
                if (snmpTrapsUserHtmlElem &&
                    (snmpTrapsUserHtmlElem.value === "user1" && !snmpUser1HtmlElem
                        || snmpTrapsUserHtmlElem.value === "user2" && !snmpUser2HtmlElem
                        || snmpTrapsUserHtmlElem.value === "user3" && !snmpUser3HtmlElem))
                {
                    snmpTrapsUserHtmlElem.value = "";
                }
                if ( areTrapsEnabled() ) {
                    snmpTrapsUserHtmlElem.setAttribute("required", "");
                } else {
                    snmpTrapsUserHtmlElem.removeAttribute("required");
                }
            }

            // show snmp_user in case it was hidden
            const snmpTrapsUserTrHtmlElem = document.getElementById("row-snmp.traps.user");
            if (snmpTrapsUserTrHtmlElem) {
                snmpTrapsUserTrHtmlElem.style.display = "";
            }

            // show users section
            const users_element = document.getElementById("users-section");
            if (users_element) {
                users_element.style.display = "";
            }
        }              
    }
}

function deviceHasTraps() {
    const element = document.getElementById('traps-panel-header');

    // Check the display style value
    return window.getComputedStyle(element).display !== "none";
}

function handleSnmpEnabledChange(enable) {
    // Get all inputs and selectors from the page to enable/disable them
    const elements = document.querySelectorAll('input, select, button');
    
    const hasTraps = deviceHasTraps();

    elements.forEach(function(element) {
        // skip the return_page input, the enable input and cancel/submit form buttons
        // skip also when traps are disabled for inputs related to traps
        if (element.name !== 'return_page' 
            && element.name !== 'snmp.main.enabled' 
            && element.id !== 'cancel' 
            && element.id !== 'submit'
            && (!element.name.startsWith('snmp.traps') || (element.name.startsWith('snmp.traps') && hasTraps))
        ) {
            element.disabled = !enable;
        }
    });
}

function handleTrapsChange() {
    // if traps are configured and protocol is v3, snmp_user is mandatory
    // if traps are not configured and protocol is v3, snmp_user is not mandatory
    if ( isProtocolV3() ) {
        const snmpTrapsUserHtmlElem = document.getElementById("snmp_user");
        if ( areTrapsEnabled() ) {
            snmpTrapsUserHtmlElem.setAttribute("required", "");
        } else {
            snmpTrapsUserHtmlElem.removeAttribute("required");
        }
    }
}

function areTrapsEnabled() {
    const primary_receiver = document.getElementById("primary_trap_receiver").value;
    const secondary_receiver = document.getElementById("secondary_trap_receiver").value;

    return primary_receiver.length !== 0 || secondary_receiver.length !== 0;
}

function isProtocolV3() {
    const protocol_version = document.getElementById("snmp_version").value;
    return protocol_version === "3";
}

function addUser(userIdx=null, userData=null) {

    const userId = "user"+userIdx;
    let tblBody = document.getElementById("usersTableBody");

    // user content
    let userDiv = document.createElement("div");
    userDiv.id = "div-"+userId;

    // title and delete button
    let tblRow = document.createElement("tr");
    let tblCell = document.createElement("td");
    tblCell.setAttribute("colspan", "2");
    const titleDiv = document.createElement("div");
    titleDiv.setAttribute("style", "display: flex; flex-direction: row; justify-content: space-between;");
    let userTitle = document.createElement("p");
    userTitle.innerHTML = "User " + userIdx;
    userTitle.className = "section-title";
    userTitle.id = userId;
    const btnDelUser = document.createElement("button");
    btnDelUser.innerText = "Delete User";
    btnDelUser.type = "button";
    btnDelUser.setAttribute('id', 'btn_delete_'+userId);
    btnDelUser.setAttribute('onclick', "deleteUser(\""+userIdx+"\")");
    titleDiv.appendChild(userTitle);
    titleDiv.appendChild(btnDelUser);
    tblCell.appendChild(titleDiv);
    tblRow.appendChild(tblCell);
    userDiv.appendChild(tblRow);

    //username
    tblRow = document.createElement("tr");
    addLabel("Username", "label", tblRow);
    let value = "";
    if (userData) {
        value = getValue(userData, userId, "username");
    }
    addInput("input-"+userId+"-username", "snmp."+userId+".username", "text", value, "largeText", null, false, null, true, null, tblRow);
    userDiv.appendChild(tblRow);

    //access
    tblRow = document.createElement("tr");
    addLabel("Access", "label", tblRow);
    value = "";
    if (userData) {
        value = getValue(userData, userId, "access");
    }
    addSelect("select-"+userId+"-access", "snmp."+userId+".access", "", ACCESS_OPTIONS, value, true, null, tblRow);
    userDiv.appendChild(tblRow);

    //auth_type
    tblRow = document.createElement("tr");
    addLabel("Authentication Type", "label", tblRow);
    value = "";
    if (userData) {
        value = getValue(userData, userId, "auth_type");
    }
    addSelect("select-"+userId+"-auth_type", "snmp."+userId+".auth_type", "", AUTH_TYPE_OPTIONS, value, true, null, tblRow);
    userDiv.appendChild(tblRow);

    //auth_passphrase
    tblRow = document.createElement("tr");
    addLabel("Authentication Passphrase", "label", tblRow);
    value = "";
    if (userData) {
        value = getValue(userData, userId, "auth_passphrase");
    }

    tblCell = document.createElement("td");
    addInput("input-"+userId+"-auth_passphrase", "snmp."+userId+".auth_passphrase", "password", value, "largeText", 8, false, null, true, null, tblCell);

    let btnShowPwd = document.createElement("button");
    btnShowPwd.type = "button";
    btnShowPwd.innerText = "Show Password";
    btnShowPwd.setAttribute('id', 'btn-show-auth_passphrase-'+userId);
    btnShowPwd.setAttribute('onclick', "showPassword(\"auth_passphrase\", \""+userId+"\")");
    tblCell.appendChild(btnShowPwd);

    let btnHidePwd = document.createElement("button");
    btnHidePwd.type = "button";
    btnHidePwd.innerText = "Hide Password";
    btnHidePwd.hidden = true;
    btnHidePwd.setAttribute('id', 'btn-hide-auth_passphrase-'+userId);
    btnHidePwd.setAttribute('onclick', "hidePassword(\"auth_passphrase\", \""+userId+"\")");
    tblCell.appendChild(btnHidePwd);

    tblRow.appendChild(tblCell);
    userDiv.appendChild(tblRow);

    //enc_type
    tblRow = document.createElement("tr");
    addLabel("Encryption Type", "label", tblRow);
    value = "";
    if (userData) {
        value = getValue(userData, userId, "enc_type");
    }
    addSelect("select-"+userId+"-enc_type", "snmp."+userId+".enc_type", "", ENC_TYPE_OPTIONS, value, true, null, tblRow);
    userDiv.appendChild(tblRow);

    //enc_passphrase
    tblRow = document.createElement("tr");
    addLabel("Encryption Passphrase", "label", tblRow);
    value = "";
    if (userData) {
        value = getValue(userData, userId, "enc_passphrase");
    }
    tblCell = document.createElement("td");
    addInput("input-"+userId+"-enc_passphrase", "snmp."+userId+".enc_passphrase", "password", value, "largeText", null, false, null, false, null, tblCell);

    btnShowPwd = document.createElement("button");
    btnShowPwd.type = "button";
    btnShowPwd.innerText = "Show Password";
    btnShowPwd.setAttribute('id', 'btn-show-enc_passphrase-'+userId);
    btnShowPwd.setAttribute('onclick', "showPassword(\"enc_passphrase\", \""+userId+"\")");
    tblCell.appendChild(btnShowPwd);

    btnHidePwd = document.createElement("button");
    btnHidePwd.type = "button";
    btnHidePwd.innerText = "Hide Password";
    btnHidePwd.hidden = true;
    btnHidePwd.setAttribute('id', 'btn-hide-enc_passphrase-'+userId);
    btnHidePwd.setAttribute('onclick', "hidePassword(\"enc_passphrase\", \""+userId+"\")");
    tblCell.appendChild(btnHidePwd);

    tblRow.appendChild(tblCell);
    userDiv.appendChild(tblRow);

    //security_level
    tblRow = document.createElement("tr");
    addLabel("Security Level", "label", tblRow);
    value = "";
    if (userData) {
        value = getValue(userData, userId, "security_level");
    }
    addSelect("select-"+userId+"-security_level", "snmp."+userId+".security_level", "", SECURITY_LEVEL_OPTIONS, value, true, null, tblRow);
    userDiv.appendChild(tblRow);

    // add user div to DOM
    tblBody.appendChild(userDiv);

    // update panel height
    commonToolsUpdatePanelHeightForElem(tblRow);

    // update traps user list
    const userOptionHtmlElem = document.getElementById("option-user"+userIdx);
    if (userOptionHtmlElem){
        userOptionHtmlElem.hidden = false;
    }

    n_users++;
    // check if addUserBtn should be disabled because max number of users was reached
    if (n_users === MAX_N_USERS) {
        const addUserBtnElem = document.getElementById("addUserBtn");
        if (addUserBtnElem){
            addUserBtnElem.disabled = true;
        }
    }
}

function reuseUser(userIdx=null) {
    const userId = "user"+userIdx;

    //username
    const usernameHtmlElement = document.getElementById("input-"+userId+"-username");
    usernameHtmlElement.setAttribute("required", true);

    //access
    const accessHtmlElement = document.getElementById("select-"+userId+"-access");
    accessHtmlElement.setAttribute("required", true);
    accessHtmlElement.selectedIndex = 0;

    //auth_type
    const authTypeHtmlElement = document.getElementById("select-"+userId+"-auth_type");
    authTypeHtmlElement.setAttribute("required", true);
    authTypeHtmlElement.selectedIndex = 0;

    //auth_passphrase
    const authPassHtmlElement = document.getElementById("input-"+userId+"-auth_passphrase");
    authPassHtmlElement.setAttribute("required", true);


    //enc_type
    const encTypeHtmlElement = document.getElementById("select-"+userId+"-enc_type");
    encTypeHtmlElement.setAttribute("required", true);
    encTypeHtmlElement.selectedIndex = 0;

    //enc_passphrase
    const encPassHtmlElement = document.getElementById("input-"+userId+"-enc_passphrase");
    encPassHtmlElement.setAttribute("required", true);

    //security_level
    const secLevelHtmlElement = document.getElementById("select-"+userId+"-security_level");
    secLevelHtmlElement.setAttribute("required", true);
    secLevelHtmlElement.selectedIndex = 0;

    n_users++;
    // check if addUserBtn should be disabled because max number of users was reached
    if (n_users === MAX_N_USERS) {
        const addUserBtnElem = document.getElementById("addUserBtn");
        if (addUserBtnElem){
            addUserBtnElem.disabled = true;
        }
    }
}

function addNewUser() {
    let userIdx = getAvailableUserIdx();

    if (userIdx !== null) {
        addUser(userIdx, null);
        return;
    }

    // if no userIdx was available, check if there is any div hidden that can be reused
    for (let i = 1; i <= MAX_N_USERS; i++) {
        const userHtmlElem = document.getElementById("div-user"+i);
        if (userHtmlElem && userHtmlElem.hidden) {
            // show div again
            userHtmlElem.hidden = false;
            reuseUser(i);
            return;
        }
    }

    console.error("Number MAX of users already reached");
}

function getAvailableUserIdx() {
    for (let i = 1; i <= MAX_N_USERS; i++) {
        const userHtmlElem = document.getElementById("div-user"+i);
        if (!userHtmlElem) {
            return i;
        }
    }

    return null;
}

function deleteUser(userIdx){
    const userHtmlElem = document.getElementById("div-user"+userIdx);

    // deleting a user is basically hiding it on the page and setting all the values as an empty string
    userHtmlElem.hidden = true;

    //username
    let htmlElem = document.getElementById("input-user"+userIdx+"-username");
    if (htmlElem) {
        htmlElem.value = "";    
    }
    htmlElem.removeAttribute("required");

    //access
    htmlElem = document.getElementById("select-user"+userIdx+"-access");
    let optionElem = document.createElement("option");
    optionElem.setAttribute("value", "");
    htmlElem.appendChild(optionElem);
    htmlElem.removeAttribute("required");
    if (htmlElem) {
        htmlElem.value = "";    
    }

    //auth_type
    htmlElem = document.getElementById("select-user"+userIdx+"-auth_type");
    optionElem = document.createElement("option");
    optionElem.setAttribute("value", "");
    htmlElem.appendChild(optionElem);
    htmlElem.removeAttribute("required");
    if (htmlElem) {
        htmlElem.value = "";    
    }

    //auth_passphrase
    htmlElem = document.getElementById("input-user"+userIdx+"-auth_passphrase");
    if (htmlElem) {
        htmlElem.value = "";    
    }
    htmlElem.removeAttribute("required");

    //enc_type
    htmlElem = document.getElementById("select-user"+userIdx+"-enc_type");
    optionElem = document.createElement("option");
    optionElem.setAttribute("value", "");
    htmlElem.appendChild(optionElem);
    htmlElem.removeAttribute("required");
    if (htmlElem) {
        htmlElem.value = "";    
    }

    //enc_passphrase
    htmlElem = document.getElementById("input-user"+userIdx+"-enc_passphrase");
    if (htmlElem) {
        htmlElem.value = "";    
    }
    htmlElem.removeAttribute("required");

    //security_level
    htmlElem = document.getElementById("select-user"+userIdx+"-security_level");
    optionElem = document.createElement("option");
    optionElem.setAttribute("value", "");
    htmlElem.appendChild(optionElem);
    htmlElem.removeAttribute("required");
    if (htmlElem) {
        htmlElem.value = "";    
    }

    // update traps user list
    const userOptionHtmlElem = document.getElementById("option-user"+userIdx);
    if (userOptionHtmlElem){
        userOptionHtmlElem.hidden = true;
    }

    const snmpTrapsUserHtmlElem = document.getElementById("snmp_user");
    if (snmpTrapsUserHtmlElem && snmpTrapsUserHtmlElem.value === "user"+userIdx) {
        snmpTrapsUserHtmlElem.value = "";
    }

    // if traps are configured and protocol is v3, snmp_user is mandatory
    // if traps are not configured and protocol is v3, snmp_user is not mandatory
    if ( isProtocolV3() ) {
        if ( areTrapsEnabled() ) {
            snmpTrapsUserHtmlElem.setAttribute("required", "");
        } else {
            snmpTrapsUserHtmlElem.removeAttribute("required");
        }
    }

    n_users--;
    // check if addUserBtn should be enabled because number of users is no longer at its maximum
    if (n_users < MAX_N_USERS) {
        const addUserBtnElem = document.getElementById("addUserBtn");
        addUserBtnElem.disabled = false;
    }
}

function renderUsers(userData, snmpEnabled, snmpVersion) {
    usersAdded = [];
    userDataLines = userData.split("\n");
    for (const userDataLine of userDataLines) {
        const uciSections = userDataLine.split(".");
        if (uciSections.length > 1 && uciSections[1].startsWith('user') && !uciSections[1].includes("=section")) {
            if ( !usersAdded.includes(uciSections[1]) ) {
                addUser(uciSections[1].replace("user",""), userDataLines);
                usersAdded.push(uciSections[1]);
            }
        }
    }

    // if last user selected doesn't exist, set snmp.traps.user selector value to empty
    const snmpTrapsUserHtmlElem = document.getElementById("snmp_user");
    const snmpUser1HtmlElem = document.getElementById("div-user1");
    const snmpUser2HtmlElem = document.getElementById("div-user2");
    const snmpUser3HtmlElem = document.getElementById("div-user3");
    if (snmpTrapsUserHtmlElem && (
        snmpTrapsUserHtmlElem.value === "user1" && !snmpUser1HtmlElem
        || snmpTrapsUserHtmlElem.value === "user2" && !snmpUser2HtmlElem
        || snmpTrapsUserHtmlElem.value === "user3" && !snmpUser3HtmlElem)) {
        snmpTrapsUserHtmlElem.value = "";
    }

    if ( isProtocolV3() ) {
        // if protocol version is 3, remove required from snmp_community input so that it can be submitted
        const community_input = document.getElementById("community");
        // remove community required
        community_input.removeAttribute("required");
        // add empty value to remove uci
        community_input.value = "";

        if ( areTrapsEnabled() ) {
            // if traps are configured and protocol is v3, snmp_user is mandatory
            snmpTrapsUserHtmlElem.setAttribute("required", "");
        } else {
            // if traps are not configured and protocol is v3, snmp_user is not mandatory
            snmpTrapsUserHtmlElem.removeAttribute("required");
        }
    } else {
        // if protocol version is 1 or 2c, remove required from snmp_user selector so that it can be submitted
        snmpTrapsUserHtmlElem.removeAttribute("required");

        // hide users
        const users_section = document.getElementById("users-section");
        if (users_section) {
            users_section.style.display = "none";
        }
    }

    // if SNMP is disabled, disable users selectors too
    if (snmpEnabled === 'false') {
        handleSnmpEnabledChange(false);
    }
}



function addInput(id, name, type="text", value="", classes=null, minlength=null, hidden=false, pattern=null, required=false, onChange=null, parent=null) {
    inputElem = document.createElement('input');
    inputElem.setAttribute("id", id);
    inputElem.setAttribute("name", name);
    inputElem.setAttribute("type", type);
    inputElem.setAttribute("value", value);
    if (classes) {
        inputElem.setAttribute("class", classes);
    }
    if (minlength) {
        inputElem.setAttribute("minlength", minlength);
    }
    if (hidden) {
        inputElem.setAttribute("hidden", true);
    }
    if (pattern) {
        inputElem.setAttribute("pattern", pattern);
    }
    if (required) {
        inputElem.setAttribute("required", true);
    }
    if (onChange) {
        inputElem.setAttribute("onChange", onChange);
    }
    if (parent) {
        parent.appendChild(inputElem);
    }
    return inputElem;
}

function addSelect(id, name, classes, options, value="", required=false, onChange=null, parent=null) {
    selectElem = document.createElement('select');
    selectElem.setAttribute("id", id);
    selectElem.setAttribute("name", name);
    selectElem.setAttribute("class", classes);
    if (onChange !== null) {
        selectElem.setAttribute("onChange", onChange);
    }
    for (const [optionKey, optionValue] of Object.entries(options)) {
        const optionElem = document.createElement("option");
        optionElem.setAttribute("value", optionValue);
        if (optionValue === value){
            optionElem.selected = true;
        }
        optionElem.innerHTML = optionKey;
        selectElem.appendChild(optionElem);
    }
    if (required){
        selectElem.setAttribute("required", true);
    }
    if (parent) {
        parent.appendChild(selectElem);
    }
    return selectElem;
}

function addLabel(label, classes, parent) {
    let labelElem = document.createElement("td");
    labelElem.innerHTML = label;
    labelElem.setAttribute("class", classes);
    if (parent){
        parent.appendChild(labelElem);
    }
    return labelElem;
}

function getValue(userDataLines, userId, key) {
    let value = "";
    for (const userDataLine of userDataLines) {
        if (userDataLine.includes(userId+"."+key)) {
            const uciKeyValue = userDataLine.split("=");
            value = uciKeyValue[1].replace(/'/g, "");
            break;
        }
    }
    return value;
}

function showPassword(passwordType, userId) {
    // change type from password to text
    const pwdInputHtmlElem = document.getElementById("input-"+userId+"-"+passwordType);
    if (pwdInputHtmlElem) {
        pwdInputHtmlElem.type = "text";
    }
    // show hide password btn
    const hidePwdHtmlElem = document.getElementById("btn-hide-"+passwordType+"-"+userId);
    if (hidePwdHtmlElem) {
        hidePwdHtmlElem.hidden = false;
    }
    // hide show password btn
    const showPwdHtmlElem = document.getElementById("btn-show-"+passwordType+"-"+userId);
    if (showPwdHtmlElem) {
        showPwdHtmlElem.hidden = true;
    }
}

function hidePassword(passwordType, userId) {
    // change type from text to password
    const pwdInputHtmlElem = document.getElementById("input-"+userId+"-"+passwordType);
    if (pwdInputHtmlElem) {
        pwdInputHtmlElem.type = "password";
    }
    // hide hide password btn
    const hidePwdHtmlElem = document.getElementById("btn-hide-"+passwordType+"-"+userId);
    if (hidePwdHtmlElem) {
        hidePwdHtmlElem.hidden = true;
    }
    // show show password btn
    const showPwdHtmlElem = document.getElementById("btn-show-"+passwordType+"-"+userId);
    if (showPwdHtmlElem) {
        showPwdHtmlElem.hidden = false;
    }
}



/**
 * Used on submit
 * @returns {boolean}
 */
function validationsBeforeSubmit() {
    return checkUserV3() && updateTrapsDestinations();
}

/**
 * Check if there is at least 1 user configured when protocol version is 3
 */
function checkUserV3() {
    const protocol_version = document.getElementById("snmp_version").value;
    if ( protocol_version === "3" && n_users === 0 ) {
        // show notification
        notify.notify({message:'At least 1 user is required for SNMP V3.', level:'danger'});
        return false;
    }
    return true;
}
