

/* password check */
function validatePassword() {
    const password = document.getElementById("pwd_set");
    const password_chk = document.getElementById("pwd_chk");
    let ret = false;
    if (password.value != password_chk.value) {
        alert("Passwords don't match! Please correct them before submitting your changes!");
    } else {
        ret = true;
    }
    return ret;
}


function test_dns_settings() {
    const ethernetDhcpElem = document.getElementById("net_proto");
    const wirelessDhcpElem = document.getElementById("wireless_proto");
    const ethernetDhcp = ethernetDhcpElem ? ethernetDhcpElem.value : null;
    const wirelessDhcp = wirelessDhcpElem ? wirelessDhcpElem.value : null;
    const selectedSsidElem = document.getElementById("select_ssid");
    let selectedSsidValue= null;
    if (selectedSsidElem)  {
        selectedSsidValue = selectedSsidElem.value;
    }

    const atLeastOneIsStatic = (ethernetDhcp === "static" || ( !!selectedSsidValue && wirelessDhcp === "static"));
    let dnsSelectorElem = document.getElementById("dns_type");
    const changeDnsTo = atLeastOneIsStatic ? "MANUAL" : dnsSelectorElem.value;

    if (dnsSelectorElem) {
        let opts = dnsSelectorElem.options;
        for (let opt, j = 0; opt = opts[j]; j++) {
            if (opt.value === changeDnsTo) {
                dnsSelectorElem.selectedIndex = j;
                break;
            }
        }
        let dnsOptionAutoElem = document.getElementById("dns_option_auto");
        if (dnsOptionAutoElem) {
            dnsOptionAutoElem.disabled = atLeastOneIsStatic;
        }
        viewDnsSettings(dnsSelectorElem.value);
    }
}


function checkHostName(elem)    {
    let hostName=elem.value;
    if (!/^[-A-Za-z0-9\.]*$/.test(hostName)){
        alert('This is a non valid hostname! Characters from A to Z, from a to z, from 0 to 9, . and - only are admitted!');
        elem.value=elem.defaultValue;
    }
}


function checkProxySettings() {
    const proxyEnabledElem = document.getElementById("proxy_enabled");
    const proxyEnabledValue = proxyEnabledElem.value;
    if (proxyEnabledValue === 'true') {
        let proxyHttpHostElem = document.getElementById("proxy_config.http.host");
        const proxyHttpHostValue = proxyHttpHostElem.value;
        if (!/^[-A-Za-z0-9\.]*$/.test(proxyHttpHostValue)) {
            alert('Proxy host is a non valid hostname! Characters from A to Z, from a to z, from 0 to 9, . and - only are admitted!');
            proxyHttpHostElem.value = proxyHttpHostElem.defaultValue;
        }
    }
}


/* local network params show function */
function viewNetworkSettings(show_static) {
    if (show_static === "static")    {
        commonToolsShowElemId('row-network.eth0.ipaddr');
        commonToolsShowElemId('row-network.eth0.netmask');
        commonToolsShowElemId('row-network.eth0.gateway');
        commonToolsHideElemId('row-network.eth0.dhcpname');
    } else {
        commonToolsHideElemId('row-network.eth0.ipaddr');
        commonToolsHideElemId('row-network.eth0.netmask');
        commonToolsHideElemId('row-network.eth0.gateway');
        commonToolsShowElemId('row-network.eth0.dhcpname');
    }
    test_dns_settings();
    commonToolsUpdatePanelHeightForId("row-network.eth0.ipaddr");
}


function viewWirelessSettings(show_static) {
    if (show_static === "static"){
        commonToolsShowElemId('row-network.wlan0.ipaddr');
        commonToolsShowElemId('row-network.wlan0.netmask');
        commonToolsShowElemId('row-network.wlan0.gateway');
        commonToolsHideElemId('row-network.wlan0.dhcpname');
    } else {
        commonToolsHideElemId('row-network.wlan0.ipaddr');
        commonToolsHideElemId('row-network.wlan0.netmask');
        commonToolsHideElemId('row-network.wlan0.gateway');
        commonToolsShowElemId('row-network.wlan0.dhcpname');
    }
    test_dns_settings();
    commonToolsUpdatePanelHeightForId("wireless_proto");
}


function viewDnsSettings(dns_type) {
    if (dns_type === 'AUTO') {
        commonToolsHideElemId('row-network.eth0.dns');
    } else {
        commonToolsShowElemId('row-network.eth0.dns');
        commonToolsUpdatePanelHeightForId("row-network.eth0.dns");
    }
}


function viewProxySettings(proxy_enabled) {
    if (proxy_enabled === 'true') {
        commonToolsShowElemId('row-proxy_config');
        commonToolsUpdatePanelHeightForId("row-proxy_config");
        checkProxySettings();
    } else {
        commonToolsHideElemId('row-proxy_config');
    }
}


function viewWifiPassword(wpa) {
    if (wpa === "NONE"){
        commonToolsHideElemId('row-network.wlan0.psk');
    } else {
        commonToolsShowElemId('row-network.wlan0.psk');
        commonToolsUpdatePanelHeightForId("row-network.wlan0.psk");
    }
}


function viewWirelessParameters(value) {
    const wireless_params = document.getElementById('wireless_parameters');
    if (!value || value.length === 0) {
        wireless_params.style.display = "none";
    } else {
        wireless_params.style.display = "block";
        commonToolsUpdatePanelHeightForId("wireless_parameters");
    }
}


function showHideWirelessSettings() {
    let displayMode = "unset";
    const wireless_uci = document.getElementById('network-wlan0');
    if (!wireless_uci || !wireless_uci.value || wireless_uci.value.length === 0) {
        displayMode = "none"
    }
    const rowWirelessHeader = document.getElementById('row-wireless-header');
    const rowWirelessSettings = document.getElementById('row-wireless-settings');
    if (rowWirelessHeader) {
        rowWirelessHeader.style.display = displayMode;
    }
    if (rowWirelessSettings) {
        rowWirelessSettings.style.display = displayMode;
    }
}


function initNetworkPage() {
    showHideWirelessSettings();
    viewNetworkSettings(document.getElementById('net_proto').value);
    viewWirelessSettings(document.getElementById('wireless_proto').value);
    viewDnsSettings(document.getElementById('dns_type').value);
    viewWifiPassword(document.getElementById('wireless_select_wpa').value);
    viewProxySettings(document.getElementById('proxy_enabled').value);
    const selectSsidElem = document.getElementById('select_ssid');
    if (selectSsidElem) {
        viewWirelessParameters(selectSsidElem.value);
    }
}


function showMicLinein(currSelection)   {
    if (currSelection === 'mic') {
        commonToolsShowElemId('mic_boost');
        commonToolsShowElemId('mic_gain');
        commonToolsShowElemId('ad_gain');
    } else {
        commonToolsHideElemId('mic_boost');
        commonToolsHideElemId('mic_gain');
        commonToolsShowElemId('ad_gain');
    }
}


function checkIntInputValue(elem,minVal,maxVal,defVal)  {
    // get the entered value
    var newValue=elem.value;
    // if not set, use the default
    if ( newValue == "" ) newValue = defVal;
    // the value must be integer number
    var newValNum=parseInt(newValue, 10);
    // ... and in the range of min-max
    if ( newValNum > maxVal ) newValNum = maxVal;
    if ( newValNum < minVal ) newValNum = minVal;
    if ( newValue != newValNum )    {
        elem.value = newValNum;
    }
}


// function showHideAecTail(aecOpt)    {
//     var tailElem=document.getElementById('aec_tail_row');
//     if (aecOpt != "disabled")   {
//         tailElem.style.display = '';
//     } else {
//         tailElem.style.display = 'none';
//     }
// }


// Load a application solution hook and run the onload function (app_network_onload)
function onload_settings(version) {
    commonToolsDynamicallyLoadScript("/app/javascript/app_settings.js?v=" + version, function () {
        if (typeof onloadAppSettingsJs === "function") {
            onloadAppSettingsJs();
        } else {
            // Enable some optional configuration rows

            let materVolumeRowElem = document.getElementById("row-application.audio.volume");
            if (materVolumeRowElem) {
                materVolumeRowElem.style.display = 'table-row';
            }

            let deviceAliasRowElem = document.getElementById("row-device.device.alias");
            if (deviceAliasRowElem) {
                deviceAliasRowElem.style.display = 'table-row';
            }
        }
    });
}


function goToHelpId(helpId)  {
    top.frames[1][1].location.href = "/cgi-bin/settings_help.cgi#" + helpId;
}


function cleanAliasInput() {
    const deviceAliasElem = document.getElementById("value-device.device.alias");
    if (deviceAliasElem) {
        const alias = deviceAliasElem.value;
        const cleanAlias = alias.replace(/[^a-zA-Z0-9 #|&\/.,\-_]/g, "");
        if (alias !== cleanAlias) {
            deviceAliasElem.value = cleanAlias;
            return false;
        } else {
            return true;
        }
    }
    return true;
}