// This code contains functions for polling device status while restarting.
// Use after config upload, factory defaults, reset, etc.

const system_ready = "/sys/cgi-bin/system_ready.cgi";
let timer_id = null;			// for setInterval / clearInterval
let show_before_restart = null;		// object to show before and while restarting
let show_after_restart = null;		// object to show after restart
let addr_prefix = null;			// address prefix to be put before the request for "system_ready"
let cbAfterRestart = null;

const SERVICE_IS_RUNNING_POOLING_INTERVAL = 500 //

function goToUrl(url, milliseconds) {
    setTimeout(function () {
        window.location.href = url;
    }, milliseconds);
}

function goToTopUrl(url, milliseconds) {
    setTimeout(function () {
        top.location.href = url;
    }, milliseconds);
}

function reloadWhenReady(){
    console.log("reloadWhenReady");
    setTimeout(function () {
        url = window.location.origin;
        if (window.XMLHttpRequest) {// code for IE7+, Firefox, Chrome, Opera, Safari
            req = new XMLHttpRequest();
            // fix for MSIE
            if (req.overrideMimeType) req.overrideMimeType("text/html; charset=ISO-8859-1");
        } else {// code for IE6, IE5
            req = new ActiveXObject("Microsoft.XMLHTTP");
        }
        req.open("GET", url, true);
        // workaround for MSIE caching problem
        req.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT");
        req.onreadystatechange = function() {
            console.log(this.readyState);
            console.log(this.status);
            if (this.readyState == 4) {
                if (this.status == 200) {
                    console.log("ready");
                    top.location.href = url;
                } else {
                    reloadWhenReady();
                }
            }
        };
        try {
          req.send();
        } catch (err) {
          console.log(err);
        }
    }, 1000);
    
}

// This is the entry function to be called from body onload
// before = HTML element id to make visible while restarting services
// after = HTML element id to make visible after
// prefix = address prefix to be prepended to the poll request; use if IP address changes
function restartingServicesSlideShow(before, after, prefix, callbackAfterRestart) {
    show_before_restart = document.getElementById(before);
    show_after_restart = document.getElementById(after);
    addr_prefix = prefix;
    cbAfterRestart = callbackAfterRestart;

    if (show_after_restart) {
        show_after_restart.style.display = "none";	// hide the "after"
    }
    if (show_before_restart) {
        show_before_restart.style.display = "block"; // show the "before"
    }

    timer_id = window.setInterval("reloadData()", SERVICE_IS_RUNNING_POOLING_INTERVAL);
}


// called on XMLHttpRequest status change
function onReadyStateChange() {
    if (this.readyState === 4 && this.status === 200) checkStatus(this.responseText);
}

function reloadData() {

    let req;
    if (window.XMLHttpRequest) {// code for IE7+, Firefox, Chrome, Opera, Safari
        req = new XMLHttpRequest();
        // fix for MSIE
        if (req.overrideMimeType) req.overrideMimeType("text/html; charset=ISO-8859-1");
    } else {// code for IE6, IE5
        req = new ActiveXObject("Microsoft.XMLHTTP");
    }
    req.open("GET", addr_prefix + system_ready, true);
    // workaround for MSIE caching problem
    req.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT");
    req.onreadystatechange = onReadyStateChange;
    try {
        req.send(null);
    } catch (err) {
    }

    return false;
}

function checkStatus(raw_data) {
    /* system is ready */
    // starts with "yes"
    if (timer_id && raw_data.indexOf("yes") === 0) {
        clearInterval(timer_id);	// stop timer
        if (show_before_restart) {
            show_before_restart.style.display = "none";	// hide the "before"
        }
        if (show_after_restart) {
            show_after_restart.style.display = "block";		// show the "after"
        }
        if (cbAfterRestart && typeof (cbAfterRestart) === typeof (Function)) {
            cbAfterRestart();
        }
    }
}