#!/usr/bin/haserl --upload-limit=10240 --upload-dir=/tmp/
content-type: text/html

<% if [ "$FORM_return_page"X = "X" ] ; then FORM_return_page="sources_ui.cgi"; fi %>
<% VERSION=$(cat /barix/info/VERSION)
%>

<html lang="en_US">
<head>
    <title>Add</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="../javascript/modal.js"></script>
    <script type="text/javascript" >
        function goToUrl(url, milliseconds)  {
            setTimeout(function(){ window.location.href = url; }, milliseconds);
        }
    </script>
</head>
<body style="background-color: #F8F8F8;">
        <% if [ -f "${FORM_uploadfile}" ] && [ $(wc -c <"${FORM_uploadfile}") -ge 133 ];then %>
            <%
                openssl x509 -in "${FORM_uploadfile}" > /dev/null
                if [ $? -eq 0 ];then
                    mkdir -p /mnt/data/ca-certificates > /dev/null; mv "${FORM_uploadfile}" "/mnt/data/ca-certificates/${POST_uploadfile_name}" > /dev/null
                    custom-ca-mgr refresh > /dev/null
                    if [ $? -eq 0 ];then
                        NOTIFICATION="${FORM_uploadfile_name} installed."
                        NOTIF_LEVEL="good"
                    else
                        NOTIFICATION="${FORM_uploadfile_name} installation failed."
                        NOTIF_LEVEL="danger"
                    fi
                else
                    NOTIFICATION="${FORM_uploadfile_name} is not a valid certificate. Not installed."
                    NOTIF_LEVEL="danger"
                fi
            %>
            <script type="text/javascript" >
                goToUrl("<% echo -n "${FORM_return_page}?notification=${NOTIFICATION}&level=$NOTIF_LEVEL" %>", 0);
            </script>
        <% else %>
            <h2>Certificates</h2>
            <h3>Upload and install certificate</h3>
            <p><br/></p>
            <div class="section1">
                    <p style="color: red;">Some problem occurs while uploading file &quot;<b><% echo -n $FORM_uploadfile_name %></b>&quot;.</p>
                    <p>Check that you are trying to upload the correct file.</p>
                    <p>Maximum upload size is <% echo -n $HASERL_UPLOAD_LIMIT %> KB.</p>
            </div>
            <p><br/></p>
            <div class="section1">
                <input type="button" value="Return to source settings" onclick="goToUrl('<% echo -n "${FORM_return_page}" %>')"/>
            <div>
        <% fi %>
</body>
</html>