<% . /usr/local/lib/cgi/haserl.sh ; check_instances status_ui.cgi %>
<% . /usr/local/lib/cgi/generic.sh ; print_http_hdr %>
<% . /usr/local/lib/cgi/status.sh %>
<% . /usr/local/lib/cgi/config.sh %>

<%
function eth0Status()   {
    OPERSTATE=$(cat /sys/class/net/eth0/operstate);
    if [ "${OPERSTATE}" = "up" ] ; then
        echo -n "Connected"
    else
        echo -n "Disconnected"
    fi
}

VERSION=$(cat /barix/info/VERSION)
%>

<html lang="en_US">
<head>
    <title>Status</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <link href="/theme/css/status.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="/javascript/common-tools.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/lics.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/status.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/wifi.js?v=<% echo -n $VERSION %>"></script>
</head>

<body onload="commonToolsIncludeHTML(); onload_status('<% echo -n $VERSION %>'); commonToolsGetAndDisplayLics(); commonToolsAddCollapsablePanelsHandlers(); renderMassStorageDevicesTable('mass-storage-devices')" style="max-width: 600px;">

    <h2>System Status</h2>

    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_top.cgi ] && echo -n '<!-- ' %>
    <div include-html="/app/cgi-bin/app_status_top.cgi?v=<% echo -n $VERSION %>"></div>
    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_top.cgi ] && echo -n ' -->' %>

    <div class="panel-header" is_open="false">Device information</div><div class="panel-body"><div class="panel-content">
        <table class="labelValue">
            <colgroup>
                <col class="label"/>
                <col class="value"/>
            </colgroup>
            <tbody>
                <tr>
                    <td class="label">Hardware type</td>
                    <td class="value"><% print_device_type %> (ID <% print_hw_type_id %>)</td>
                </tr>
                <tr>
                    <td class="label">IPAM type</td>
                    <td class="value"><% print_ipam_type %> (ID <% print_module_type_id %>)</td>
                </tr>
                <tr>
                    <td class="label">MAC address</td>
                    <td class="value"><% print_mac_addr %></td>
                </tr>
                <!--
                <tr>
                    <td class="label">Firmware </td>
                    <td class="value">Flexa</td>
                </tr>
                <tr>
                    <td class="label">Firmware version</td>
                    <td class="value"><% print_fw_version %></td>
                </tr>
                <tr>
                    <td class="label">Application</td>
                    <td class="value"><% uci -q get flexa_app.AppParam.app_name %> </td>
                </tr>
                <tr>
                    <td class="label">Application version</td>
                    <td class="value"> <% uci -q get flexa_app.AppParam.version %> </td>
                </tr>
                -->
                <tr>
                    <td class="label">Linux kernel version</td>
                    <td class="value"> <% print_kernel_version %></td>
                </tr>
                <tr>
                    <td class="label">Bootloader version</td>
                    <td class="value"> <% print_bootloader_version %></td>
                </tr>
            </tbody>
        </table>
    </div></div>


    <div class="panel-header" is_open="false">Network</div><div class="panel-body"><div class="panel-content">
        <table class="labelValue">
            <colgroup>
                <col class="label"/>
                <col class="value"/>
            </colgroup>
            <tbody>
                <tr>
                    <td class="label">
                        <h4>Wired Connection</h4>
                    </td>
                    <td/>
                </tr>
                <tr>
                    <td colspan="2">
                        <table class="section3">
                            <colgroup>
                                <col class="label"/>
                                <col class="value"/>
                            </colgroup>
                            <tbody>
                                <tr>
                                    <td class="label">Status</td>
                                    <td class="value"><% eth0Status %></td>
                                </tr>
                                <tr>
                                    <td class="label">IP address</td>
                                    <td class="value"><% print_ip_addr %></td>
                                </tr>
                                <tr>
                                    <td class="label">Netmask</td>
                                    <td class="value"><% print_netmask %></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>

                <tr id="row-status-wifi-connection-header" style="display: none;">
                    <td class="label">
                        <h4>Wireless Connection</h4>
                    </td>
                    <td/>
                </tr>
                <tr id="row-status-wifi-connection" style="display: none;">
                    <td colspan="2">
                        <table class="section3">
                            <colgroup>
                                <col class="label"/>
                                <col class="value"/>
                            </colgroup>
                            <tbody>
                                <tr>
                                    <td class="label">Status</td>
                                    <td class="value" id="value-wifi-state"></td>
                                </tr>
                                <tr>
                                    <td class="label">MAC address</td>
                                    <td class="value" id="value-wifi-mac_address"></td>
                                </tr>
                                <tr>
                                    <td class="label">SSID</td>
                                    <td class="value" id="value-wifi-ssid"></td>
                                </tr>
                                <tr>
                                    <td class="label">Signal strength</td>
                                    <td class="value" id="value-wifi-rssi"></td>
                                </tr>
                                <tr>
                                    <td class="label">IP address</td>
                                    <td class="value" id="value-wifi-ip_address"></td>
                                </tr>
                                <tr>
                                    <td class="label">Netmask</td>
                                    <td class="value" id="value-wifi-net_mask"></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>

                <tr>
                    <td class="label">Default gateway</td>
                    <td class="value"><% print_default_gw %></td>
                </tr>
                <tr>
                    <td class="label">DNS servers</td>
                    <td class="value">
                        <% if cfg_string_compare network.eth0.dns_type "AUTO" ; then
                             echo -n 'Auto';
                           else
                             echo -n $(cfg_print_param network.eth0.dns1)'<br/>'$(cfg_print_param network.eth0.dns2)
                           fi
                        %>
                    </td>
                </tr>

            </tbody>
        </table>
    </div></div>


    <div class="panel-header">System</div><div class="panel-body"><div class="panel-content">
        <table class="labelValue">
            <colgroup>
                <col class="label"/>
                <col class="value"/>
            </colgroup>
            <tbody>
                <tr>
                    <td class="label">System time (refresh)</td>
                    <td class="value"><% date %></td>
                </tr>
                <tr>
                    <td class="label">Uptime</td>
                    <td class="value"><% print_uptime %></td>
                </tr>
            </tbody>
        </table>

        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_system_bottom.cgi ] && echo -n '<!-- ' %>
        <div include-html="/app/cgi-bin/app_status_system_bottom.cgi?v=<% echo -n $VERSION %>"></div>
        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_system_bottom.cgi ] && echo -n ' -->' %>

    </div></div>


    <div class="panel-header">Licenses</div><div class="panel-body"><div class="panel-content">
        <div id="lic_placeholder">
           verifying licences...
        </div>
    </div></div>


    <div class="panel-header">Mass storage devices</div><div class="panel-body"><div class="panel-content">
        <div  id="mass-storage-devices"></div>
    </div></div>

    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_bottom.cgi ] && echo -n '<!-- ' %>
    <div include-html="/app/cgi-bin/app_status_bottom.cgi?v=<% echo -n $VERSION %>"></div>
    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_bottom.cgi ] && echo -n ' -->' %>

    <div style="width: calc(100% - 16px); text-align: right; color: #888888; margin: 16px 0; font-size: small;">
        <a href="/open-source-licenses.html" target="licenses">Open Source Licenses</a>
    </div>

    <br>
    <img class="send-cmd-img" id="send_cmd_img" src="">
</body>
</html>

