<% VERSION=$(cat /barix/info/VERSION) %>

<html lang="en_US">
<head>
    <title>Flexa Help</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <script src="/javascript/common-tools.js?v=<% echo -n $VERSION %>"></script>
</head>

<body class="help" onload=commonToolsIncludeHTML();>
    <div class="help">
        <h2>Help</h2>
    
        <h3>SNMP Settings</h3>
        <table>
            <tbody>
                <tr>
                    <td>
                        On this section of the page you can configure everything related to SNMP.
                    </td>
                </tr>
            </tbody>
        </table>

        <h4 id="snmp">Enable SNMP</h4>
        <p class="help">
            Enable or disable the SNMP functionality.<br>
            Default: <em>"Disabled"</em><br>
        </p>

        <h4 id="snmp_ver">Protocol Version</h4>
        <p class="help">
            The SNMP protocol version used by this device.<br>
            Accepted values are <em>1</em>, <em>2c</em>, and <em>3</em>.<br>
        </p>

        <h4 id="snmp_port">SNMP Port</h4>
        <p class="help">
            Sets the UDP port on which the device is responding to SNMP requests.<br>
            Default: <em>"161"</em><br>
        </p>

        <h4 id="snmp_syscontact">Contact</h4>
        <p class="help">
            Defines the contact of the person responsible for managing this device via SNMP.<br>
            Default: <em>"root@this.ip.com"</em><br>
        </p>

        <h4 id="snmp_sysname">Name</h4>
        <p class="help">
            Defines the SNMP system name of this device.<br>
            Default: <em>"Barix FLEXA device"</em><br>
        </p>

        <h4  id="snmp_syslocation">Location</h4>
        <p class="help">
            Defines the SNMP system location of this device.<br>
            Default: <em>"Please update me!"</em><br>
        </p>

        <h4  id="snmp_ro_community">Read-Only Community</h4>
        <p class="help">
            Set here the name of the community, that will have read access to the SNMP values, reported by this device.<br>
            <b><em>Note: </em></b>When the Read-Only Community name is not explicitly set (empty), the name "public" is assumed.<br>
            Default: <em>"public"</em><br>
        </p>

        <h4  id="snmp_rw_community">Read-Write Community</h4>
        <p class="help">
            Set here the name of the community, that will have RW access to the SNMP values, reported by this device.<br>
            <b><em>Note: </em></b>When the Read-Write Community name is not explicitly set (empty), the SNMP SET function is disabled (no write access).<br>
            Default: <em>"private"</em><br>
        </p>

        <h4 id="snmp_user_engine_id">Engine ID</h4>
        <p class="help">
            The “Engine ID” field is unique per device.<br>
            When empty, one is automatically generated.<br>
            Only strings without spaces or special characters are accepted.<br>
            SNMP prepends an header to this string when sending the packets. <br>
            The header is hardcoded to <em>0x80001f8804</em> (hexadecimal format).
        </p>

        <h3>SNMP Users</h3>
        <p>
            Only available for SNMP version 3.
        </p>

        <h4 id="snmp_user_name">Username</h4>
        <p class="help">
            A name for an SNMP v3 user.<br>
            Up to 3 users can be created.<br>
        </p>

        <h4 id="snmp_user_access">Access</h4>
        <p class="help">
            Access control for the user.<br>
            Accepted values are: <em>“ro”</em> (read-only) or <em>“rw”</em> (read-write).<br>
        </p>        

        <h4 id="snmp_user_auth_type">Authentication Type</h4>
        <p class="help">
            Authentication type.<br>
            Accepted values are <em>MD5</em> or <em>SHA</em>.<br>
        </p>

        <h4 id="snmp_user_auth_pass">Authentication Passphrase</h4>
        <p class="help">
            The passphrase for user authentication.<br>
            The minimum pass phrase length is 8 characters.<br>
        </p>

        <h4 id="snmp_user_enc_type">Encryption Type</h4>
        <p class="help">
            Encryption type.<br>
            Accepted values are <em>DES</em> or <em>AES</em>.<br>
        </p>

        <h4 id="snmp_user_enc_pass">Encryption Passphrase</h4>
        <p class="help">
            Encryption passphrase.<br>
            When empty, the authentication passphrase is used.<br>
        </p>

        <h4 id="snmp_user_security_level">Security Level</h4>
        <p class="help">
            The minimum security level.<br>
            The possible values are:
            <ul>
                <li class="help"><em>noauth</em>:  unauthenticated and/or non-encrypted requests are possible.</li>
                <li class="help"><em>auth</em>: only authenticated requests are allowed, encrypted or non-encrypted.</li>
                <li class="help"><em>priv</em>: only authenticated and encrypted requests are allowed.</li>
            </ul>
        </p>
        
        <%
            # Checks whether it is supposed to show SNMP traps configuration
            SNMP_TRAPS=0
            DEVICE_FEATURES_FILE="/tmp/device_features"
            if [ -f "$DEVICE_FEATURES_FILE" ]; then
                VALUE=$(jq -r --arg key "show_snmp_traps" '.[$key] // empty' "$DEVICE_FEATURES_FILE")
                if [ ! -z "$VALUE" ]; then # if key exists in file
                    if [ "$VALUE" == "true" ]; then # if should show SNMP traps configuration
                        SNMP_TRAPS=1
                    fi    
                fi
            fi
        %>

        <div <% if [ $SNMP_TRAPS -eq 0 ]; then echo -n 'style="display: none"'; fi %>>
            <h3>SNMP Traps</h3>

            <h4 id="snmp_community">Community</h4>
            <p class="help">
                Set the Community to be used for SNMP traps.<br>
                Available only for Protocol Version's v1 and v2c.<br>
                Empty community values are accepted.<br>
            </p>

            <h4 id="snmp_primary_trap_receiver">Primary Trap Receiver</h4>
            <p class="help">
                The primary server where to send traps for enabled inputs.<br>
                Configuration expected: <em>IP_ADDR:PORT</em><br>
                Default value: <em>empty</em><br>
            </p>

            <h4 id="snmp_secondary_trap_receiver">Secondary Trap Receiver</h4>
            <p class="help">
                The secondary server where to send traps for enabled inputs.<br>
                Configuration expected: <em>IP_ADDR:PORT</em><br>
                Default value: <em>empty</em><br>
            </p>

            <h4 id="snmp_repeat">Repeat</h4>
            <p class="help">
                When an input is active, the trap will be issued repeatedly respecting the interval specified, in seconds.<br>
            </p>

            <h4 id="snmp_inputs">Digital Inputs</h4>
            <p class="help">
                Select for which inputs you want to activate traps.<br>
                Traps are sent when the digital inputs of this list change their state.<br>
            </p>

            <h4 id="snmp_send_on_boot">Send on boot</h4>
            <p class="help">
                When traps are enabled for an input, typically the device sends the trap for that input when the unit boots. In some occasions, this is not desired because it could trigger undesired alarms.<br> 
                For this reason we need to provide an option to disable the trap sent at boot.<br>
                Default value: <em>enabled</em><br>
            </p>

            <h4 id="snmp_user">User</h4>
            <p class="help">
                Select the user to be used on traps.<br>
                Available only for SNMP V3.<br>
                Required when traps are enabled (i.e. when at least one trap receiver is configured).<br>
            </p>
        </div>

    </div>

</body>
</html>
