<% . /usr/local/lib/cgi/haserl.sh ; check_instances snmp_traps.cgi %>
<% . /usr/local/lib/cgi/config.sh%>
<% . /lib/config/functions.sh
VERSION=$(cat /barix/info/VERSION)
%>
<%  
    N_DIGITAL_INPUTS=0
    DEVICE_FEATURES_FILE="/tmp/device_features"
    if [ -f "$DEVICE_FEATURES_FILE" ]; then
        VALUE=$(jq -r --arg key "hw_capabilities.inputs" 'getpath($key | split(".") // empty)' "$DEVICE_FEATURES_FILE")
        if [ ! -z "$VALUE" ]; then # if key exists in file
            N_DIGITAL_INPUTS=$VALUE
        fi
    fi
%> 

<html lang="en_US">
<head>
    <title>SNMP</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <link href="/theme/css/modal.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="/javascript/common-tools.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/snmp.js?v=<% echo -n $VERSION %>"></script>
    <!-- Notification Popup -->
    <link rel="stylesheet" href="/theme/css/notify.css?v=<% echo -n $VERSION %>">
    <script src="/notify/notify.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" >
        function showNotification() {
            <%  if [ "$FORM_notification" != "" ] ; then
                    if [ -z ${FORM_level+x} ]; then
                        echo -n "notify.notify({message:'$FORM_notification', level:'good'});"
                    else
                        echo -n "notify.notify({message:'$FORM_notification', level:'$FORM_level'});"
                    fi
                fi
            %>
        }
    </script>
    <style>
        input:invalid {
            border: 1px solid red;
        }
    </style>
</head>

<%
    USER_UCI_VALUES=$(uci -q show snmp);
    USERS=$(echo "$USER_UCI_VALUES" | sed "s/'/\\\'/g" | sed ':a;N;$!ba;s/\n/\\n/g');
%>


<body onload="commonToolsIncludeHTML(); showNotification(); commonToolsAddCollapsablePanelsHandlers(); renderUsers('<% printf "%s" "$USERS" %>', '<% cfg_print_param snmp.main.enabled %>', '<% cfg_print_param snmp.traps.snmp_version %>');" style="max-width: 600px;">

    <div id="page-content">

    <h2>SNMP Settings</h2>

    <form name="settings" action="config.cgi" method="POST">

        <input type="hidden" name="return_page" value="snmp.cgi"/>

        <div>
            <table class="labelValue">
                <colgroup>
                    <col class="label"/>
                    <col class="value"/>
                </colgroup>
                <tbody>
                    <tr id="row-snmp.main.enabled" onClick="goToHelpId('snmp')">
                        <td class="label">Enable SNMP</td>
                        <td class="value value-check-button">
                            <input  type="radio" 
                                    name="snmp.main.enabled" 
                                    value="false" 
                                    <% if ! cfg_bool_is_true "snmp.main.enabled"; then echo -n " checked"; fi %>
                                    onchange="handleSnmpEnabledChange(false);"
                            >Disabled
                            <input  type="radio" 
                                    name="snmp.main.enabled" 
                                    value="true" 
                                    <% if cfg_bool_is_true "snmp.main.enabled"; then echo -n " checked"; fi %>
                                    onchange="handleSnmpEnabledChange(true);"
                            >Enabled
                        </td>
                    </tr>
                    <tr id="row-snmp.main.snmp_version" onClick="goToHelpId('snmp_ver')">
                        <td class="label">Protocol Version</td>
                        <td class="value value-check-button">
                            <select class="shortText" id="snmp_version" name="snmp.main.snmp_version" onchange="snmpVersionChanged()" <% if ! cfg_bool_is_true "snmp.main.enabled"; then echo -n " disabled"; fi %> required>
                                <option value="1" <% if cfg_string_compare snmp.main.snmp_version 1 ; then echo -n 'selected="selected"'; fi %>>1</option>
                                <option value="2c" <% if cfg_string_compare snmp.main.snmp_version 2c ; then echo -n 'selected="selected"'; fi %>>2c</option>
                                <option value="3" <% if cfg_string_compare snmp.main.snmp_version 3 ; then echo -n 'selected="selected"'; fi %>>3</option>
                            </select>
                        </td>
                    </tr>
                    <tr id="row-snmp.main.port" onClick="goToHelpId('snmp_port')">
                        <td class="label">SNMP port</td>
                        <td class="value"><input name="snmp.main.port" class="largeText" size="5" maxlength="5" value="<% cfg_print_param snmp.main.port %>" onchange="checkIntInputValue(this,1,65535,161);" <% if ! cfg_bool_is_true "snmp.main.enabled"; then echo -n " disabled"; fi %>></td>
                    </tr>
                    <tr id="row-snmp.system.syscontact" onClick="goToHelpId('snmp_syscontact')" style="<% conditional_display snmp %>">
                        <td class="label">Contact</td>
                        <td class="value"><input name="snmp.system.syscontact" class="largeText" size="20" maxlength=31 value="<% cfg_print_param snmp.system.syscontact %>" <% if ! cfg_bool_is_true "snmp.main.enabled"; then echo -n " disabled"; fi %>></td>
                    </tr>
                    <tr id="row-snmp.system.sysname" onClick="goToHelpId('snmp_sysname')" style="<% conditional_display snmp %>">
                        <td class="label">Name</td>
                        <td class="value"><input name="snmp.system.sysname" class="largeText" size="20" maxlength=31 value="<% cfg_print_param snmp.system.sysname %>" <% if ! cfg_bool_is_true "snmp.main.enabled"; then echo -n " disabled"; fi %>></td>
                    </tr>
                    <tr id="row-snmp.system.syslocation" onClick="goToHelpId('snmp_syslocation')" style="<% conditional_display snmp %>">
                        <td class="label">Location</td>
                        <td class="value"><input name="snmp.system.syslocation" class="largeText" size="20" maxlength=31 value="<% cfg_print_param snmp.system.syslocation %>" <% if ! cfg_bool_is_true "snmp.main.enabled"; then echo -n " disabled"; fi %>></td>
                    </tr>
                    <tr id="row-snmp.security.ro_community" onClick="goToHelpId('snmp_ro_community')" style="<% conditional_display snmp %>">
                        <td class="label">Read-Only Community</td>
                        <td class="value"><input name="snmp.security.ro_community" class="largeText" size="20" maxlength=31 value="<% cfg_print_param snmp.security.ro_community %>" onchange="this.value=this.value.replace(/[^a-zA-Z0-9]/g,'');" <% if ! cfg_bool_is_true "snmp.main.enabled"; then echo -n " disabled"; fi %>></td>
                    </tr>
                    <tr id="row-snmp.security.rw_community" onClick="goToHelpId('snmp_rw_community')" style="<% conditional_display snmp %>">
                        <td class="label">Read-Write Community</td>
                        <td class="value"><input name="snmp.security.rw_community" class="largeText" size="20" maxlength=31 value="<% cfg_print_param snmp.security.rw_community %>" onchange="this.value=this.value.replace(/[^a-zA-Z0-9]/g,'');" <% if ! cfg_bool_is_true "snmp.main.enabled"; then echo -n " disabled"; fi %>></td>
                    </tr>
                    <tr>
                        <td class="label">Engine ID</td>
                        <td class="value"><input id="input-users-engineId" name="snmp.security.engineid" class="largeText" pattern="^[0-9a-zA-Z]*$" value="<% cfg_print_param snmp.security.engineid %>" <% if ! cfg_bool_is_true "snmp.main.enabled"; then echo -n " disabled"; fi %> />
                        </td>
                    </tr>
                </tbody>
            </table>

            <!----------- USERS SECTION ----------->

            <div id="users-section">
                <div class="panel-header">SNMP Users</div><div class="panel-body"><div class="panel-content">
                    <button type="button" id="addUserBtn" onClick="addNewUser()">Add User</button>
                    <table class="labelValue">
                        <colgroup>
                            <col class="label"/>
                            <col class="value"/>
                        </colgroup>
                        <tbody id="usersTableBody">
                        </tbody>
                    </table>
                </div></div></div>
            </div>




            <!----------- TRAPS SECTION ----------->

            <%
                # Checks whether it is supposed to show SNMP traps configuration
                SNMP_TRAPS=0
                DEVICE_FEATURES_FILE="/tmp/device_features"
                if [ -f "$DEVICE_FEATURES_FILE" ]; then
                    VALUE=$(jq -r --arg key "show_snmp_traps" '.[$key] // empty' "$DEVICE_FEATURES_FILE")
                    if [ ! -z "$VALUE" ]; then # if key exists in file
                        if [ "$VALUE" == "true" ]; then # if should show SNMP traps configuration
                            SNMP_TRAPS=1
                        fi    
                    fi
                fi
            %>
        
            <div class="panel-header" id="traps-panel-header" <% if [ $SNMP_TRAPS -eq 0 ]; then echo -n 'style="display: none"'; fi %> >Trap Settings</div><div class="panel-body"><div class="panel-content">
                <table class="labelValue">
                    <colgroup>
                        <col class="label"/>
                        <col class="value"/>
                    </colgroup>
                    <tbody>
                        <tr id="row-snmp.traps.community" onClick="goToHelpId('snmp_community')" <% if [[ "$(uci -q get snmp.main.snmp_version)" == "3" ]]; then echo 'style="display: none"'; fi%>>
                            <td class="label">Community</td>
                            <td class="value">
                                <input  class="mediumText" 
                                        id="community" 
                                        name="snmp.traps.community" 
                                        value="<% echo $(uci -q get snmp.traps.community) %>"
                                        <% if ! ( cfg_bool_is_true "snmp.main.enabled" && [ "$SNMP_TRAPS" -ne 0 ]; ); then echo -n " disabled"; fi %>>
                            </td>
                        </tr>
                        <%
                            snmp_traps_destinations_uci_val=$(uci -q get snmp.traps.destinations);
                            snmp_receiver_1="";
                            snmp_receiver_2="";
                            if [ ! -z "$snmp_traps_destinations_uci_val" ] ; then
                                # Split the input string into an array
                                read -ra elements <<< "$snmp_traps_destinations_uci_val"

                                # Check elements size
                                length=${#elements[@]}

                                if [ "$length" -gt 0 ]; then
                                    snmp_receiver_1=${elements[0]};
                                fi
                                if [ "$length" -gt 1 ]; then
                                    snmp_receiver_2=${elements[1]};
                                fi
                            fi
                        %>
                        <input type="hidden" id="snmp_traps_destinations" name="snmp.traps.destinations" value="">
                        <tr id="row-snmp.traps.primary_trap_receiver" onClick="goToHelpId('snmp_primary_trap_receiver')">
                            <td class="label">Primary Trap Receiver</td>
                            <td class="value">
                                <input  class="mediumText" 
                                        id="primary_trap_receiver"
                                        name="snmp.traps.destinations_1"
                                        value="<% echo $snmp_receiver_1 %>"
                                        pattern="^((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])(:([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]))?|()$" 
                                        title="Expected IP_ADDR:PORT"
                                        <% if ! ( cfg_bool_is_true "snmp.main.enabled" && [ "$SNMP_TRAPS" -ne 0 ]; ); then echo -n " disabled"; fi %>
                                        onchange="handleTrapsChange();">
                            </td>
                        </tr>
                        <tr id="row-snmp.traps.secondary_trap_receiver" onClick="goToHelpId('snmp_secondary_trap_receiver')">
                            <td class="label">Secondary Trap Receiver</td>
                            <td class="value">
                                <input  class="mediumText" 
                                        id="secondary_trap_receiver" 
                                        name="snmp.traps.destinations_2"
                                        value="<% echo $snmp_receiver_2 %>"
                                        pattern="^((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9]?[0-9])(:([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]))?|()$" 
                                        title="Expected IP_ADDR:PORT"
                                        <% if ! ( cfg_bool_is_true "snmp.main.enabled" && [ "$SNMP_TRAPS" -ne 0 ]; ); then echo -n " disabled"; fi %>
                                        onchange="handleTrapsChange();">
                            </td>
                        </tr>
                        <tr id="row-snmp.traps.repeat" onClick="goToHelpId('snmp_repeat')">
                            <td class="label">Repeat Time</td>
                            <td class="value">
                                <input  type="number" 
                                        name="snmp.traps.barionet_repeat" 
                                        class="smallText" 
                                        value="<% cfg_print_param snmp.traps.barionet_repeat %>"
                                        min="0"
                                        required
                                        <% if ! ( cfg_bool_is_true "snmp.main.enabled" && [ "$SNMP_TRAPS" -ne 0 ]; ); then echo -n " disabled"; fi %>>
                            </td>
                        </tr>
                        <tr id="row-snmp.traps.barionet_inputs" onClick="goToHelpId('snmp_inputs')" <% if [ "$N_DIGITAL_INPUTS" -eq 0 ]; then echo 'hidden'; fi%>>
                            <td class="label">Digital Inputs</td>
                            <td class="value value-check-button">
                                <%  
                                    uci_val=$(uci -q get snmp.traps.barionet_inputs);
                                    echo -n '<input hidden id="snmp_traps_barionet_inputs" name="snmp.traps.barionet_inputs" value="'$uci_val;
                                    echo -n '">';
                                    i=1;
                                    while [ $i -le $N_DIGITAL_INPUTS ]; do
                                        echo -n '<div>';
                                        echo -n '<input type="checkbox" id="chk-input-'$i;
                                        echo -n '" onclick="updateInputsList('$i;
                                        echo -n ')"'
                                        if [ ! -z "$uci_val" ] ; then
                                            pattern="(^|\s)$i($|\s)"
                                            found=$(echo "$uci_val" | grep -E "$pattern");
                                            # if exists, prints uci_val. if not, prints nothing
                                            if [ ! -z "${found}" ]; then
                                                echo -n ' checked';
                                            fi
                                        fi
                                        if ! ( cfg_bool_is_true "snmp.main.enabled" && [ "$SNMP_TRAPS" -ne 0 ]; ); 
                                            then echo -n " disabled"; 
                                        fi
                                        echo -n '/>';
                                        echo -n '<label for="chk-input-'$i;
                                        echo -n '">Input'$i;
                                        echo -n '</label>';
                                        echo -n '</div>';
                                        i=$((i + 1))
                                    done
                                %> 
                            </td>
                        </tr>
                        <tr id="row-snmp.traps.barionet_sendonboot" onClick="goToHelpId('snmp_send_on_boot')">
                            <td class="label">Enable trap at boot</td>
                            <td class="value value-check-button">
                                <input type="radio" name="snmp.traps.barionet_sendonboot" value="false" <% if ! cfg_bool_is_true "snmp.traps.barionet_sendonboot"; then echo -n " checked"; fi %> <% if ! ( cfg_bool_is_true "snmp.main.enabled" && [ "$SNMP_TRAPS" -ne 0 ]; ); then echo -n " disabled"; fi %>>Disabled
                                <input type="radio" name="snmp.traps.barionet_sendonboot" value="true" <% if cfg_bool_is_true "snmp.traps.barionet_sendonboot"; then echo -n " checked"; fi %> <% if ! ( cfg_bool_is_true "snmp.main.enabled" && [ "$SNMP_TRAPS" -ne 0 ]; ); then echo -n " disabled"; fi %>>Enabled
                            </td>
                        </tr>
                        <tr id="row-snmp.traps.user" onClick="goToHelpId('snmp_user')" <% if [[ "$(uci -q get snmp.main.snmp_version)" != "3" ]]; then echo 'style="display: none"'; fi%>>
                            <td class="label">User</td>
                            <td class="value">
                                <select class="shortText" id="snmp_user" name="snmp.traps.user" <% if ! ( cfg_bool_is_true "snmp.main.enabled" && [ "$SNMP_TRAPS" -ne 0 ]; ); then echo -n " disabled"; fi %>>
                                    <option id="option-user1" value="user1" <% if cfg_string_compare snmp.traps.user user1 && cfg_string_compare snmp.user1 section ; then echo -n 'selected="selected"'; fi %> hidden>User 1</option>
                                    <option id="option-user2" value="user2" <% if cfg_string_compare snmp.traps.user user2 && cfg_string_compare snmp.user2 section ; then echo -n 'selected="selected"'; fi %> hidden>User 2</option>
                                    <option id="option-user3" value="user3" <% if cfg_string_compare snmp.traps.user user3 && cfg_string_compare snmp.user3 section ; then echo -n 'selected="selected"'; fi %> hidden>User 3</option>
                                </select>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div></div>

            <hr style="width: calc(100vw - 48px); max-width: 600px;">

            <table class="section1 sources" cellspacing="0" cellpadding="3" style="width: 100%;">
                <tbody>
                    <tr>
                        <td align="right">
                            <button id="cancel" class="red" onClick="window.location.reload(); return false;" title="Restore settings">Cancel</button>
                            <button id="submit" class="green" type="submit" target="_self" onClick="return validationsBeforeSubmit();" title="Apply settings">Submit</button>
                        </td>
                    </tr>
                </tbody>
            </table>

        </div>
    </form>
    </div>


    <!-- LOADING SPINNER -->
    <div id="loading-spinner" style="display: none; width: 100%; text-align: center; top: calc(25vh); position: absolute;">
        <div id="loading" class="loading-ripple">
            <div></div>
            <div></div>
        </div>
        <div  style="width: 90%; margin: 48px auto 0; color: #333333; font-family: SourceSansPro, Arial, Helvetica, sans-serif; font-size:19px; font-weight:400; text-align:center;">
            <h3>Processing...</h3>
        </div>
    </div>

</body>
</html>
