<% . /usr/local/lib/cgi/haserl.sh ; check_instances settings_ui.cgi %>
<% . /usr/local/lib/cgi/generic.sh ; print_http_hdr %>
<% . /usr/local/lib/cgi/status.sh %>
<% . /usr/local/lib/cgi/config.sh
VERSION=$(cat /barix/info/VERSION)
%>

<html lang="en_US">
<head>
    <title>Settings</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <link href="/theme/css/modal.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <link href="/theme/css/loading.css?v=<% echo -n $VERSION %>" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="/sys/js/util.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/common-tools.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/settings.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/wifi.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/modal.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/upload-certificate.js?v=<% echo -n $VERSION %>"></script>
    <script type="text/javascript" src="/javascript/certificates.js?v=<% echo -n $VERSION %>"></script>

    <script language="javascript">
        function showNotification() {
            <%
                if [ "$FORM_notification" != "" ] ; then
                    if [ -z ${FORM_level+x} ] ; then
                        echo -n "notify.notify({message:'$FORM_notification', level:'attention'});"
                    else
                        echo -n "notify.notify({message:'$FORM_notification', level:'$FORM_level'});"
                    fi
                fi
            %>
        }
    </script>

    <!-- Notification Popup -->
    <link rel="stylesheet" href="/theme/css/notify.css?v=<% echo -n $VERSION %>">
    <script src="/notify/notify.js?v=<% echo -n $VERSION %>"></script>

</head>

<% 
SHOW_SONIC_IP=0
uci_val=$(uci -q show sonic_ip); 
if [ "X$uci_val" != "X" ] ; then
    DEVICE_FEATURES_FILE="/tmp/device_features"
    if [ -f "$DEVICE_FEATURES_FILE" ]; then
        if jq -e --arg str "sonic-ip" '.hidden_features[] | select(. == $str)' "$DEVICE_FEATURES_FILE" > /dev/null; then
            SHOW_SONIC_IP=0
        else
            SHOW_SONIC_IP=1
        fi
    else
        SHOW_SONIC_IP=1
    fi
fi
%>

<body onload="commonToolsIncludeHTML(); onload_settings('<% echo -n $VERSION %>'); renderWirelessSsidOptions('<% cfg_print_param network.wlan0.ssid %>'); initNetworkPage(); showNotification(); commonToolsAddCollapsablePanelsHandlers(); renderCertificateList();" style="max-width: 600px;">

    <div id="page-content">
    <form name="settings" action="config.cgi" method="POST">

        <input type="hidden" name="return_page" value="settings_ui.cgi"/>

        <div>
            <div class="section1" style="margin-top: 16px;">
                <table class="labelValue">
                     <colgroup>
                         <col class="label"/>
                         <col class="value"/>
                     </colgroup>
                     <tbody>
                         <tr id="row-device.device.alias" style="display: none;">
                            <td class="label">Device Alias</td>
                            <td class="value">
                                <input name="device.device.alias" id="value-device.device.alias" class="mediumText" value="<% cfg_print_param device.device.alias %>" onkeyup="cleanAliasInput()" />
                            </td>
                         </tr>
                         <tr id="row-application.audio.volume" style="display: none;">
                             <td class="label">Master Volume</td>
                             <td class="value">
                                <div class="slider-content">
                                    <div class="slider-left">
                                        <input id="master-vol"
                                            class="slider"
                                            type="range" min="0" max="100" step="1"
                                            value="<% cfg_print_param application.audio.volume %>"
                                            name="application.audio.volume"
                                            oninput="onSliderInput('master-vol')"
                                            onchange="onMasterVolumeChange()"/>
                                    </div>
                                    <div id="master-vol-value" class="slider-right">
                                        <% cfg_print_param application.audio.volume %>%
                                    </div>
                                </div>
                             </td>
                         </tr>
                     </tbody>
                 </table>
            </div>

            <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_top.cgi ] && echo -n '<!-- ' %>
            <div include-html="/app/cgi-bin/app_settings_top.cgi?v=<% echo -n $VERSION %>"></div>
            <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_top.cgi ] && echo -n ' -->' %>

            <div class="panel-header">Network Settings</div><div class="panel-body"><div class="panel-content">
                <table class="labelValue">
                    <colgroup>
                        <col class="label"/>
                        <col class="value"/>
                    </colgroup>
                    <tbody>
                        <tr id="row-sonic_ip.general.enabled" onClick="goToHelpId('sonic_ip')" style="<% if [ $SHOW_SONIC_IP -eq 0 ]; then echo -n 'display: none;'; else echo -n 'display: table-row;'; fi %>">

                            <td class="label">SonicIP</td>
                            <td class="value value-check-button"><% form_print_radio sonic_ip.general.enabled Enabled Disabled %> </td>
                        </tr>
                        <tr id="row-sonic_ip.general.volume" onClick="goToHelpId('sonic_ip')" style="<% if [ $SHOW_SONIC_IP -eq 0 ]; then echo -n 'display: none;'; else echo -n 'display: table-row;'; fi %>">

                            <td class="label">SonicIP volume</td>
                            <td class="value">
                                <div class="slider-content">
                                    <div class="slider-left">
                                        <input id="sonicip-vol"
                                            class="slider"
                                            type="range" min="0" max="100" step="1"
                                            value="<% cfg_print_param sonic_ip.general.volume %>"
                                            name="sonic_ip.general.volume"
                                            oninput="onSliderInput('sonicip-vol')"
                                            onchange="onSonicIpVolumeChange()"/>
                                    </div>
                                    <div id="sonicip-vol-value" class="slider-right">
                                        <% cfg_print_param sonic_ip.general.volume %>%
                                    </div>
                                </div>
                             </td>
                        </tr>
                        <tr id="row-httpd.webserver.protocol" onClick="goToHelpId('web_protocol')">
                            <td class="label">Web protocol</td>
                            <td class="value">
                                <select class="shortText" id="web_protocol" name="httpd.webserver.protocol">
                                    <option value="http" <% if cfg_string_compare httpd.webserver.protocol http ; then echo -n 'selected="selected"'; fi %>>HTTP</option>
                                    <option value="https" <% if cfg_string_compare httpd.webserver.protocol https ; then echo -n 'selected="selected"'; fi %>>HTTPS</option>
                                </select>
                            </td>
                        </tr>
                        <tr id="row-syslogd.remote.ipaddr" style="<% conditional_display syslogd %>">
                            <td class="label">Syslog Address</td>
                            <td class="value"><input name="syslogd.remote.ipaddr" class="mediumText" maxlength="15" value="<% cfg_print_param syslogd.remote.ipaddr %>" onChange="IPAddrCheck(this,1)"/></td>
                        </tr>


                        <!-- Ethernet -->
                         <tr onClick="goToHelpId('ethernet')">
                             <td class="label">
                                 <h4>Ethernet</h4>
                             </td>
                             <td/>
                         </tr>
                        <tr onClick="goToHelpId('ethernet')">
                            <td colspan="2">
                                <table class="section3">
                                    <colgroup>
                                        <col class="label"/>
                                        <col class="value"/>
                                    </colgroup>
                                    <tbody>
                                        <tr id="row-network.eth0.proto">
                                            <td class="label-sec2">DHCP</td>
                                            <td class="value">
                                                <select class="shortText" id="net_proto" name="network.eth0.proto" onchange="viewNetworkSettings(this.value)">
                                                    <option value="dhcp" <% if cfg_string_compare network.eth0.proto dhcp ; then echo -n 'selected="selected"'; fi %>>Yes</option>
                                                    <option value="static" <% if cfg_string_compare network.eth0.proto static ; then echo -n 'selected="selected"'; fi %>>No</option>
                                                </select>
                                            </td>
                                        </tr>
                                        <tr id="row-network.eth0.ipaddr" >
                                            <td class="label-sec2">IP Address</td>
                                            <td class="value"><input name="network.eth0.ipaddr" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.ipaddr %>" onChange="IPAddrCheck(this,0)"/></td>
                                        </tr>
                                        <tr id="row-network.eth0.netmask" >
                                            <td class="label-sec2">Netmask</td>
                                            <td class="value"><input name="network.eth0.netmask" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.netmask %>" onChange="NetmaskCheck(this)"/></td>
                                        </tr>
                                        <tr id="row-network.eth0.gateway" >
                                            <td class="label-sec2">Gateway IP Address</td>
                                            <td class="value"><input name="network.eth0.gateway" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.gateway %>" onChange="IPAddrCheck(this,1)"/></td>
                                        </tr>
                                        <!--
                                            <tr id="row-httpd.webserver.port">
                                                <td class="label-sec2">Web Server Port</td>
                                                <td class="value"><input name="httpd.webserver.port" type="number" class="mediumNumber" maxlength="5" value="<% cfg_print_param httpd.webserver.port %>" onChange="PortCheck(this,1)"/>
                                                </td>
                                            </tr>
                                        -->
                                        <tr id="row-network.eth0.dhcpname">
                                            <td class="label-sec2">DHCP host name</td>
                                            <td class="value"><input name="network.eth0.dhcpname" class="largeText" maxlength="32" value="<% cfg_print_param network.eth0.dhcpname %>" onChange="checkHostName(this)"/></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>

                        <!-- Wireless -->
                        <tr id="row-wireless-header" onClick="goToHelpId('wireless')">
                            <td class="label"><h4>Wireless<div id="value-wireless-status-dot"/></h4></td>
                            <td><input type="hidden" name="network-wlan0" id="network-wlan0" value="<% cfg_print_param network.wlan0 %>"/></td>
                        </tr>
                        <tr id="row-wireless-settings">
                            <td colspan="2">
                                <table class="section3" onClick="goToHelpId('wireless')">
                                    <colgroup>
                                        <col class="label-sec2"/>
                                        <col class="value"/>
                                    </colgroup>
                                    <tbody>
                                        <tr id="row-network.wlan0.ssid">
                                            <td class="label-sec2">SSID</td>
                                            <td class="value" id="wireless_select_ssid"/>
                                        </tr>
                                        <tr>
                                            <td colspan=2>
                                                <table id="wireless_parameters" style="margin: -2px; display: none;">
                                                    <colgroup>
                                                        <col class="label-sec2"/>
                                                        <col class="value"/>
                                                    </colgroup>
                                                    <tbody>
                                                        <tr id="row-network.wlan0.security">
                                                            <td class="label-sec2">Security</td>
                                                            <td class="value">
                                                                <select class="mediumText" id="wireless_select_wpa" name="network.wlan0.security" onchange="viewWifiPassword(this.value)">
                                                                    <option value="NONE" <% if cfg_string_compare network.wlan0.security NONE ; then echo -n 'selected="selected"'; fi %>>none</option>
                                                                    <option value="WPA" <% if cfg_string_compare network.wlan0.security WPA ; then echo -n 'selected="selected"'; fi %>>WPA</option>
                                                                </select>
                                                            <td/>
                                                        </tr>
                                                        <tr id="row-network.wlan0.psk" style="display: none;">
                                                            <td class="label-sec2">Password</td>
                                                            <td class="value">
                                                                <input name="network.wlan0.psk" id="wireless_pwd" type="password" minlength="8" maxlength="63" class="mediumText" placeholder="Password"/>
                                                            <td/>
                                                        </tr>
                                                        <tr id="row-network.wlan0.proto">
                                                            <td class="label-sec2">DHCP</td>
                                                            <td class="value">
                                                                <select class="shortText" id="wireless_proto" name="network.wlan0.proto" onchange="viewWirelessSettings(this.value)">
                                                                    <option value="dhcp" selected>yes</option>
                                                                    <option value="static" disabled>no</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                        <tr id="row-network.wlan0.ipaddr" >
                                                            <td class="label-sec2">IP Address</td>
                                                            <td class="value">
                                                                <font size=2><input name="network.wlan0.ipaddr" maxlength="15" class="mediumText" value="<% cfg_print_param network.wlan0.ipaddr %>" onChange="IPAddrCheck(this,0)"/></font>
                                                            </td>
                                                        </tr>
                                                        <tr id="row-network.wlan0.netmask" >
                                                            <td class="label-sec2">Netmask</td>
                                                            <td class="value">
                                                                <font size=2><input name="network.wlan0.netmask" maxlength="15" class="mediumText" value="<% cfg_print_param network.wlan0.netmask %>" onChange="NetmaskCheck(this)"/></font>
                                                            </td>
                                                        </tr>
                                                        <tr id="row-network.wlan0.gateway" >
                                                            <td class="label-sec2">Gateway</td>
                                                            <td class="value">
                                                                <font size=2><input name="network.wlan0.gateway" maxlength="15" class="mediumText" value="<% cfg_print_param network.wlan0.gateway %>" onChange="IPAddrCheck(this,1)"/></font>
                                                            </td>
                                                        </tr>
                                                        <tr id="row-network.wlan0.dhcpname">
                                                            <td class="label-sec2">DHCP host name</td>
                                                            <td class="value">
                                                                <input name="network.wlan0.dhcpname" maxlength="32" class="largeText" value="<% cfg_print_param network.wlan0.dhcpname %>" onChange="checkHostName(this)"/>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>

                        <tr id="row-network.eth0.dns_type" onClick="goToHelpId('dns')">
                            <td class="label">DNS</td>
                            <td class="value">
                                <select class="shortText" id="dns_type" name="network.eth0.dns_type" onchange="viewDnsSettings(this.value)">
                                    <option id="dns_option_auto" value="AUTO" <% if cfg_string_compare network.eth0.dns_type "AUTO" ; then echo -n 'selected="selected"'; fi %>>Auto</option>
                                    <option value="MANUAL" <% if cfg_string_compare network.eth0.dns_type "MANUAL" ; then echo -n 'selected="selected"'; fi %>>Manual</option>
                                </select>
                            </td>
                        </tr>

                        <tr id="row-network.eth0.dns" onClick="goToHelpId('dns')">
                            <td colspan="2">
                                <table class="section3">
                                    <colgroup>
                                        <col class="label-sec2"/>
                                        <col class="value"/>
                                    </colgroup>
                                    <tbody>
                                        <tr id="row-network.eth0.dns1" >
                                            <td class="label">Primary DNS</td>
                                            <td class="value"><input name="network.eth0.dns1" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.dns1 %>" onChange="IPAddrCheck(this,1)"/></td>
                                        </tr>
                                        <tr id="row-network.eth0.dns2" >
                                            <td class="label">Alternative&nbsp;DNS</td>
                                            <td class="value"><input name="network.eth0.dns2" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.dns2 %>" onChange="IPAddrCheck(this,1)"/></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>

                        <tr id="row-proxy_config.http.enable" onClick="goToHelpId('proxy')" style="<% conditional_display proxy_config %>">
                            <td class="label">Use proxy</td>
                            <td class="value">
                                <select class="shortText" id="proxy_enabled" name="proxy_config.http.enable" onchange="viewProxySettings(this.value)">
                                    <option id="proxy_config_http_enable_false" value="false" <% if cfg_string_compare proxy_config.http.enable "false" ; then echo -n 'selected="selected"'; fi %>>No</option>
                                    <option value="true" <% if cfg_string_compare proxy_config.http.enable "true" ; then echo -n 'selected="selected"'; fi %>>Yes</option>
                                </select>
                            </td>
                        </tr>

                        <tr id="row-proxy_config">
                            <td colspan="2">
                                <table class="section3" onClick="goToHelpId('proxy')">
                                    <colgroup>
                                        <col class="label-sec2"/>
                                        <col class="value"/>
                                    </colgroup>
                                    <tbody>
                                        <tr id="row-proxy_config.http.host" title="Proxy url">
                                            <td class="label">Host</td>
                                            <td class="value"><input name="proxy_config.http.host" id="proxy_config.http.host" class="largeText" maxlength="64" value="<% cfg_print_param proxy_config.http.host %>" onChange="checkProxySettings()"/></td>
                                        </tr>
                                        <tr id="row-proxy_config.http.port" title="Proxy port">
                                            <td class="label">Port</td>
                                            <td class="value"><input name="proxy_config.http.port" type="number" class="mediumNumber" maxlength="5" value="<% cfg_print_param proxy_config.http.port %>"/></td>
                                        </tr>
                                        <tr id="row-proxy_config.http.username" title="Proxy user name">
                                            <td class="label">User name</td>
                                            <td class="value"><input name="proxy_config.http.username" class="mediumText" maxlength="64" value="<% cfg_print_param proxy_config.http.username %>"/></td>
                                        </tr>
                                        <tr id="row-proxy_config.http.password" title="Proxy user password">
                                            <td class="label">User password</td>
                                            <td class="value"><input name="proxy_config.http.password" type="password" class="mediumText" maxlength="64" value="<% cfg_print_param proxy_config.http.password %>"/></td>
                                        </tr>
                                        <tr id="row-proxy_config.general.no_proxy" title="Proxy exception list as comma separated entries. If empty, mean no exceptions">
                                            <td class="label">Exceptions</td>
                                            <td class="value"><input name="proxy_config.general.no_proxy" id="proxy_config.general.no_proxy" class="largeText" maxlength="64" value="<% cfg_print_param proxy_config.general.no_proxy %>"/></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                        <tr id="row-network.avahi.enabled" onClick="goToHelpId('avahi')" style="<% conditional_display avahi %>">
                            <td class="label">Avahi announce</td>
                            <td class="value value-check-button"><% form_print_radio avahi.general.enabled Enabled Disabled %> </td>
                        </tr>

                    </tbody>
                </table>
            </div></div>

            <div class="panel-header">Time Settings</div><div class="panel-body"><div class="panel-content">
                <table class="labelValue">
                    <colgroup>
                        <col class="label"/>
                        <col class="value"/>
                    </colgroup>
                    <tbody>
                        <!--
                            <tr id="row-rtc.rtc.enabled">
                                <td class="label">RTC</td>
                                <td class="value">
                                    <select name="rtc.rtc.enabled" class="shortText">
                                        <option value="true" <% if cfg_string_compare rtc.rtc.enabled true ; then echo -n 'selected="selected"'; fi %>>enabled</option>
                                        <option value="false" <% if cfg_string_compare rtc.rtc.enabled false ; then echo -n 'selected="selected"'; fi %>>disabled</option>
                                    </select>
                                </td>
                            </tr>
                        -->
                        <tr id="row-ntp.source.server1" onClick="goToHelpId('ntp')">
                            <td class="label">NTP server 1</td>
                            <td class="value"><input name="ntp.source.server1" class="mediumText" value="<% cfg_print_param ntp.source.server1 %>"/></td>
                        </tr>
                        <tr id="row-ntp.source.server2" onClick="goToHelpId('ntp')">
                            <td class="label">NTP server 2</td>
                            <td class="value"><input name="ntp.source.server2" class="mediumText" value="<% cfg_print_param ntp.source.server2 %>"/></td>
                        </tr>
                        <tr id="row-ntp.source.server3" onClick="goToHelpId('ntp')">
                            <td class="label">NTP server 3</td>
                            <td class="value"><input name="ntp.source.server3" class="mediumText" value="<% cfg_print_param ntp.source.server3 %>"/></td>
                        </tr>
                    </tbody>
                </table>
            </div></div>

            <div class="panel-header">Security Settings</div><div class="panel-body"><div class="panel-content">
                <table class="labelValue">
                    <colgroup>
                        <col class="label"/>
                        <col class="value"/>
                    </colgroup>
                    <tbody>
                    <tr id="row-security.defaults.enabled" onClick="goToHelpId('security')">
                        <td class="label">Reset factory defaults</td>
                        <td class="value value-check-button"><% form_print_radio security.defaults.enabled Enabled Disabled %> </td>
                    </tr>
                    <tr id="row-security.update.enabled" onClick="goToHelpId('security')">
                        <td class="label">Update function</td>
                        <td class="value value-check-button"><% form_print_radio security.update.enabled Enabled Disabled %> </td>
                    </tr>
                    <tr id="row-security.reset.enabled" onClick="goToHelpId('security')">
                        <td class="label">Reboot function</td>
                        <td class="value value-check-button"><% form_print_radio security.reset.enabled Enabled Disabled %> </td>
                    </tr>
                    <%
                    if ! cfg_string_compare httpd.webserver.password_set "true" ; then
                        echo -n '
                        <tr id="row-httpd.webserver.password_set" onClick="goToHelpId('\''security'\'')">
                            <td class="label">Web UI Password</td>
                            <td class="value">
                                <input name="pwd_set" class="smallText" id="pwd_set" type="password" maxlength="16" placeholder="Password"/>
                                <input id="pwd_chk" class="smallText" type="password" maxlength="16" placeholder="Confirm Password"/>
                            </td>
                        </tr> '
                    else
                        echo -n '
                        <tr id="row-httpd.webserver.password_set" onClick="goToHelpId('\''security'\'')">
                            <td class="label">Web UI password</td>
                            <td class="value">
                                <input name="pwd_old" class="smallText" type="password" maxlength="16" placeholder="old password"/>
                                <input name="pwd_new" class="smallText" id="pwd_set" type="password" maxlength="16" placeholder="new password"/>
                                <input id="pwd_chk" class="smallText" type="password" maxlength="16" placeholder="confirm password"/>
                             </td>
                        </tr> '
                    fi
                    %>

                        <tr id="row-dropbear.RunCtl.enable" onClick="goToHelpId('\''ssh'\'')">
                            <td class="label-sec2">SSH</td>
                            <td class="value">
                                <select class="shortText" id="dropbear-RunCtl-enable" name="dropbear.RunCtl.enable">
                                    <option value="0" <% if cfg_string_compare dropbear.RunCtl.enable "0" ; then echo -n 'selected="selected"'; fi %>>disabled</option>
                                    <option value="1" <% if cfg_string_compare dropbear.RunCtl.enable "1" ; then echo -n 'selected="selected"'; fi %>>enabled</option>
                                </select>
                            </td>
                        </tr>

                    </tbody>
                </table>

                <h4>Additional Certificates</h4>
                <table class="section1 sources" cellspacing="0" cellpadding="3" style="width: 100%;" onClick="goToHelpId('\''certificates'\'')">
                    <tbody>
                        <tr>
                            <td align="right">
                                <input type="button" onclick="uploadHandler('upload-modal');" title="Upload certificate file" value="Install certificate"/>
                            </td>
                        </tr>
                    </tbody>
                </table>

                <div class="section1">
                    <div id="certificate-list"></div>
                </div>

            </div></div>

            <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_bottom.cgi ] && echo -n '<!-- ' %>
            <div include-html="/app/cgi-bin/app_settings_bottom.cgi?v=<% echo -n $VERSION %>"></div>
            <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_bottom.cgi ] && echo -n ' -->' %>

            <hr style="width: calc(100vw - 48px); max-width: 600px;">

            <table class="section1 sources" cellspacing="0" cellpadding="3" style="width: 100%;">
                <tbody>
                    <tr>
                        <td align="right">
                            <button class="red" onClick="window.location.reload(); return false;" title="Restore settings">Cancel</button>
                            <button class="green" type="submit" target="_self" onClick="return validatePassword();" title="Apply settings">Submit</button>
                        </td>
                    </tr>
                </tbody>
            </table>

        </div>
    </form>
    </div>


    <!-- LOADING SPINNER -->
    <div id="loading-spinner" style="display: none; width: 100%; text-align: center; top: calc(25vh); position: absolute;">
        <div id="loading" class="loading-ripple">
            <div></div>
            <div></div>
        </div>
        <div  style="width: 90%; margin: 48px auto 0; color: #333333; font-family: SourceSansPro, Arial, Helvetica, sans-serif; font-size:19px; font-weight:400; text-align:center;">
            <h3>Processing...</h3>
        </div>
    </div>


    <!-- CONTENT OF UPLOAD MODAL -->
    <div id="upload-modal" style="display: none;">
        <div template="title">
            Upload certificate
        </div>
        <div template="body">
            <form id="upload-form" name="upload-form" action="upload-certificate.cgi" class="upload-form" style="width: 100%;" method="POST" enctype="multipart/form-data">
                <input type="hidden" name="return_page" value="settings_ui.cgi">
                <table class="section1" cellspacing="0" cellpadding="3" align="center" style="width: 96%; height: 120px;">
                    <tbody>
                        <tr>
                            <td style="vertical-align: bottom;">
                                <input id="filename" type="file" accept=".crt" name="uploadfile" onchange="checkFileIsValid()" style="width: 100%;"/>
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: right; vertical-align: bottom;">
                                <button id="upload-button" type="submit" disabled="disabled" title="Upload audio file" onclick="closePopup('upload-modal'); commonToolsHideElemId('page-content'); commonToolsShowElemId('loading-spinner');">Upload and install certificate</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </form>
        </div>
    </div>


</body>
</html>
