<html lang="en_US">
<head>
    <title>Network Help</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css" rel="stylesheet" type="text/css">
    <script src="/javascript/common-tools.js"></script>
    <% [ ! -f /usr/local/www/current/app/javascript/app_settings.js ] && echo -n '<!-- ' %>
    <script src="/app/javascript/app_settings.js"></script>
    <% [ ! -f /usr/local/www/current/app/javascript/app_settings.js ] && echo -n ' -->' %>
</head>

<body class="help" onload="commonToolsIncludeHTML(); onloadAppSettingsHelpJs();">
    <div class="help">
        <h2>Help</h2>
        <!--
        <h4>Device Alias</h4>
        <p class="help">Define a alias for the device. Useful for distinguishing multiple devices on the same network and browser favorites. Need to reload page to view changes.</p>
        -->

        <% [ ! -f /usr/local/www/current/app/app_settings_help_top.html ] && echo -n '<!-- ' %>
        <div include-html="/app/app_settings_help_top.html"></div>
        <% [ ! -f /usr/local/www/current/app/app_settings_help_top.html ] && echo -n ' -->' %>

        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_help_top.cgi ] && echo -n '<!-- ' %>
        <div include-html="/app/cgi-bin/app_settings_help_top.cgi"></div>
        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_help_top.cgi ] && echo -n ' -->' %>

        <h3>Network Settings</h3>

        <div>
            <div id="help-avahi">
                <h4 id="avahi">Avahi announce</h4>
                <p class="help">
                    If set to <em>"yes"</em>, the Avahi announce daemon is activated.<br>
                    This daemon implements zero-configuration networking,
                    including a system for multicast DNS/DNS-SD service discovery<br>
                    Default: <em>"no"</em>
                </p>
            </div>

            <% 
                SHOW_SONIC_IP=0
                uci_val=$(uci -q show sonic_ip); 
                if [ "X$uci_val" != "X" ] ; then
                    DEVICE_FEATURES_FILE="/tmp/device_features"
                    if [ -f "$DEVICE_FEATURES_FILE" ]; then
                        if jq -e --arg str "sonic-ip" '.hidden_features[] | select(. == $str)' "$DEVICE_FEATURES_FILE" > /dev/null; then
                            SHOW_SONIC_IP=0
                        else
                            SHOW_SONIC_IP=1
                        fi
                    else
                        SHOW_SONIC_IP=1
                    fi
                fi

                if [ $SHOW_SONIC_IP -eq 1 ]; then 
                    echo '<!--
                    <h4>SonicIP<sup>&reg;</sup></h4>
                    <p class="help">
                        If set to <em>"yes"</em>, the device will announce its IP address over the audio output.<br>
                        Default: <em>"yes"</em>
                    </p>
                    -->

                    <h4 id="sonic_ip">SonicIP<sup>&reg;</sup> Volume</h4>
                    <p class="help">
                        Sets the volume at which the SonicIP<sup>&reg;</sup> will be announced at boot.<br>
                        Default: <em>"50 %"</em>
                    </p>'; 
                fi
            %>

            <h4 id="web_protocol">Web Protocol</h4>
            <p class="help">
                Changing the web protocol from HTTP to HTTPS secures the web connection with the device web interface (web server) encrypting the communication. This parameter it is not affecting the HTTP audio stream functionality.<br>
                Default: <em>"HTTP"</em> <br>
            </p>
            <p class="help">
                <em>Note:</em> After changing the protocol make sure to reload the page with the proper URL "http://" or "https://"
            </p>

            <h4 id="ethernet">Ethernet DHCP</h4>
            <p class="help">
                Enable "DHCP" for automatic assignment of IP address, Netmask, Gateway and Primary/Alternative DNS.<br>
                Select "Static" for manually assigning IP address, Netmask, Gateway and Primary/Alternative DNS.<br>
            </p>
            <p class="help">
                <em>Note:</em> If set to "Static" all fields are mandatory (except Alternative DNS and Syslog Address).<br>
            </p>
            <p class="help">
                Default: <em>"Yes"</em>
            </p>

            <h4>Ethernet DHCP host name</h4>
            <p class="help">
                When <em>"DHCP"</em> is selected as protocol, you can optionally set a DHCP host name to be sent in the DHCP request.
            </p>

            <div id="wireless-help">

                <h4 id="wireless">Wireless SSID</h4>
                <p class="help">
                    Select the service set identifier.
                </p>

                <h4>Wireless Security</h4>
                <p class="help">
                    Select the type of security to SSID.
                </p>

                <h4>Wireless Password</h4>
                <p class="help">
                    Define the SSID password.
                </p>

                <h4>Wireless Method</h4>
                <p class="help">
                    Define the Dynamic Host Configuration Protocol like ethernet.
                </p>

                <h4>Wireless DHCP host name</h4>
                <p class="help">
                    Define the Dynamic Host Configuration Protocol Name like ethernet.
                </p>

            </div>

            <h4 id="dns">DNS</h4>
            <p class="help">
                Select the method to define a Domain Name System.
            </p>

            <div class="section1">
                <h5>Primary DNS</h5>
                <p class="help">
                    Define manually the primary Domain Name System.
                </p>

                <h5>Alternative DNS</h5>
                <p class="help">
                    Define manually the alternative Domain Name System.
                </p>
            </div>

            <div id="proxy-help">

                <h4 id="proxy">Use proxy</h4>
                <p class="help">
                    Enable/disable proxy settings
                </p>

                <div class="section1">
                    <h5>Host</h5>
                    <p class="help">
                        The proxy server hostname/IP address
                    </p>

                    <h5>Port</h5>
                    <p class="help">
                        The proxy server port
                    </p>

                    <h5>User name</h5>
                    <p class="help">
                        The proxy user name
                    </p>

                    <h5>User password</h5>
                    <p class="help">
                        The proxy user password
                    </p>

                    <h5>Exceptions</h5>
                    <p class="help">
                        Proxy exception as a list of comma separated entries. If empty, mean no exceptions.
                        Allowed format for entries
                        <ul>
                           <li><i>host</i> - "host", exactly</li>
                           <li><i>.host</i> - all subdomains of "host"</li>
                           <li><i>nnn.nnn.nnn.nnn</i> - an ip address</li>
                           <li><i>nnn.nnn.nnn.</i> - all ip addresses starting with "nnn.nnn.nnn."</li>
                        </ul>
                    </p>
                </div>
            </div>

        </div>

        <h3 id="ntp">Time Settings</h3>
        <div>
            <p class="help">
                Allows to set up to 3 NTP servers for internet time adjustment.
            </p>
        </div>

        <h3 id="security">Security Settings</h3>
        <div>
            <h4>Reboot Function</h4>
            <p class="help">
                Enable or disable the &quot;Reboot&quot; function with the RESET button and from the WEB UI REBOOT tab.<br>
                Default: <em>"enabled"</em>
            </p>

            <h4>Reset factory defaults</h4>
            <p class="help">
                Enable or disable the &quot;Reset Factory Defaults&quot; feature from both web UI &quot;DEFAULTS&quot; tab and device front panel RESET button. In order to revert all settings to factory defaults click on the &quot;Defaults&quot; web UI page, or keep the Reset button pressed for more than 10 seconds. <br>
                Default: <em>"enabled"</em>
            </p>

            <h4>Update function</h4>
            <p class="help">
                Enable or disable the WEB Update function of the device.<br>
                Default: <em>"enabled"</em>
            </p>

            <h4>Automatic remote update</h4>
            <p class="help">
                Enable or disable the automatic update of the device.<br>
                Please note that the device must be connected to the Internet.<br>
                Default: <em>"enabled"</em>
            </p>

            <h4>Web UI password</h4>
            <p class="help">
                This group of fields is visible as long as no password is set.<br>
                Enter the <em>admin</em> password (up to 16 characters) both in the "Password" and "Confirm Password" fields, then click the "Submit" button. After the restart you should close the browser window and open a new browser window. You will be asked to supply user name and password. Use the default <em>admin</em> user name and the password that you have just set in order to access the web UI.<br>
            </p>

            <h4 id="ssh">SSH</h4>
            <p class="help">
                SSH might be useful in some support cases. Enable it only when Barix support asks you to do so, else leave it Disable to avoid the device listening on the ssh port while operating.
                Default: <em>"disabled"</em>
            </p>

            <h4 id="certificates">Additional Certificates</h4>
            <p class="help">
                Upload here additional Certificates (.crt) file that might be required to secure the connection with the device
            </p>

        </div>

        <% [ ! -f /usr/local/www/current/app/app_settings_help_bottom.html ] && echo -n '<!-- ' %>
        <div include-html="/app/app_settings_help_bottom.html"></div>
        <% [ ! -f /usr/local/www/current/app/app_settings_help_bottom.html ] && echo -n ' -->' %>

        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_help_bottom.cgi ] && echo -n '<!-- ' %>
        <div include-html="/app/cgi-bin/app_settings_help_bottom.cgi"></div>
        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_help_bottom.cgi ] && echo -n ' -->' %>

        <br>

    </div>

</body>
</html>
