<% 
. /usr/local/lib/cgi/generic.sh 
. /usr/local/lib/cgi/config.sh


# Extract application name from manifest
APP_NAME=`python /usr/local/www/current/scripts/getManifestProperty.py name`

# Set the parent page title according manifest
function getAppName()   {
	if [ ! -z "${APP_NAME}" ]; then echo -n "${APP_NAME}"; else echo -n "BarixDevice"; fi
}

DEV_NAME=$(getAppName)
TIME_TAG=$(date +%Y%m%d%H%M%S)
MAC_ADDR=$(cat /sys/class/net/eth0/address | tr "[a-z]" "[A-Z]" | tr ":" "-")

#
#   Collect and pack all device info to send as logs
#

DIAGNOSTICS="/var/log/diagnostics"

rm -rf $DIAGNOSTICS
mkdir $DIAGNOSTICS

env > $DIAGNOSTICS/environment.txt

uci show > $DIAGNOSTICS/uci_config.txt

tar czf $DIAGNOSTICS/conf.tar.gz -C /mnt/data conf

uptime > $DIAGNOSTICS/uptime.txt

top -b -n 5 > $DIAGNOSTICS/top_samples.txt

cp /proc/meminfo $DIAGNOSTICS/meminfo.txt

tar czf $DIAGNOSTICS/netstats.tar.gz -C /proc/net .

# ping -c 10 player.manage.barix.com > $DIAGNOSTICS/ping_portal.txt

# traceroute player.manage.barix.com > $DIAGNOSTICS/traceroute_portal.txt

cp /etc/resolv.conf $DIAGNOSTICS/resolv.conf

cp /etc/network/interfaces $DIAGNOSTICS/network_interfaces.txt

df -h > $DIAGNOSTICS/filesystem_usage.txt

# nslookup 1.barix.pool.ntp.org > $DIAGNOSTICS/lookup_ntp.txt

# nslookup barixupdate.com > $DIAGNOSTICS/lookup_downloads.txt

echo "NO_INFO" > $DIAGNOSTICS/factory_info
echo "NO_INFO" > $DIAGNOSTICS/factory_info.json

cp /tmp/factory_info_partition/factory_info $DIAGNOSTICS/factory_info
cp /tmp/factory_info_partition/factory_info_json $DIAGNOSTICS/factory_info.json

tar cp -R /mnt/data/conf/ $DIAGNOSTICS/conf

cd /var/log
echo "Content-Disposition: attachment; filename=${DEV_NAME}_${MAC_ADDR}_${TIME_TAG}_logs.tar.gz"
print_http_hdr text/plain
tar -cv *  | gzip -c
%>