#!/usr/bin/haserl --upload-limit=10240 --upload-dir=/tmp/
content-type: text/html

<% if [ "$FORM_return_page"X = "X" ] ; then FORM_return_page="settings_ui.cgi"; fi

COUNTER=0;

function deleteFromList()   {
    OLD_IFS=$IFS
    IFS=';' read -r -a DELELE_FILES <<< "${2}"
    IFS=$OLD_IFS
    for FILE in "${DELELE_FILES[@]}"; do
        rm -f "/mnt/data/ca-certificates/${FILE}" > /dev/null
        STATUS=$?
        if [ $STATUS -eq 0 ]; then
            COUNTER=$((COUNTER+1))
        fi
    done
    IFS=$OLD_IFS
}

%>

<html lang="en_US">
<head>
    <title>Delete Certificates</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/theme/css/main.css" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="../javascript/modal.js"></script>
    <script type="text/javascript" >
        function goToUrl(url, milliseconds)  {
            setTimeout(function(){ window.location.href = url; }, milliseconds);
        }
    </script>
</head>
<body>
    <%
       if [ ! -z ${POST_delete_custom_list+x} ]; then
           deleteFromList "/mnt/data/ca-certificates" "${POST_delete_custom_list}"
           custom-ca-mgr refresh > /dev/null
       fi
    %>
    <script type="text/javascript" >
        <%
            MESSAGE="";
            NOTIF_LEVEL="attention";
            case "$COUNTER" in
                0)
                    MESSAGE="No certificates have been removed"
                    NOTIF_LEVEL="danger"
                    ;;
                1)
                    MESSAGE="$COUNTER certificate was removed"
                    NOTIF_LEVEL="good"
                    ;;
                *)
                    MESSAGE="$COUNTER certificates have been removed"
                    NOTIF_LEVEL="good"
                    ;;
            esac
        %>
        goToUrl("<% echo -n "${POST_return_page}?notification=$MESSAGE&level=$NOTIF_LEVEL" %>", 0);
    </script>
</body>
</html>