<% . /usr/local/lib/cgi/generic.sh ; print_http_hdr %>
<% . /usr/local/lib/cgi/status.sh %>
<% . /usr/local/lib/cgi/config.sh %>
<% 

# adds key:value to the control.json, which is used
# to load web ui parameters at runtime
# params:
#   $1: key 
#   $2: value

CTRLJSON=/mnt/data/package/control.json

add_to_control_json() {

    new_json_pair="{\"$1\":\"$2\"}"

    if [ ! -f "${CTRLJSON}" ] ; then
      echo "creating ${CTRLJSON}"
      echo "{ }" > ${CTRLJSON}
    fi

    if [ ! -f "${CTRLJSON}_new" ] ; then
      echo "creating tmp file"
      touch ${CTRLJSON}_tmp
    fi

    jq --argjson to_add ${new_json_pair} '. + $to_add' < ${CTRLJSON} > ${CTRLJSON}_tmp
    cp ${CTRLJSON}_tmp ${CTRLJSON}
    rm ${CTRLJSON}_tmp

}

if [ "$FORM_get_player_status" != "" ] ; then

    appl_name=$( uci get flexa_agent.service.appl_name )

    app_state="false"

    if [ -n "${appl_name}" ]; then
        pid=$(cat "/var/run/${appl_name}.pid")
        [ -n "${pid}" -a -d "/proc/${pid}" ] && app_state="true"
    fi

    jsonObj="{ \"app_state\":${app_state}}"

    echo ${jsonObj}
fi


if [ "$FORM_app_stop" != "" ] ; then
    logger "stopping flexa app"
    /etc/init.d/run-flexa stop
fi


if [ "$FORM_app_start" != "" ] ; then
    logger "starting flexa app"
    echo -e $(set -o posix ; set) >> /tmp/run-flexa.log
    echo "/etc/init.d/run-flexa start" > /tmp/launch_app
fi


if [ "$FORM_reconnect" != "" ] ; then
    logger "flexa reconnect"
    /usr/bin/flexa-agent reset
    echo "/usr/bin/flexa-agent" > /tmp/launch_app
fi


if [ "$FORM_sync" != "" ] ; then
    logger "flexa sync"
    echo "/usr/bin/flexa-agent" > /tmp/launch_app
fi


if [ "$FORM_make_call" != "" ] ; then
    logger "call uri: "$FORM_make_call
    uci set flexa_app.AppParam.make_call_uri=$FORM_make_call
fi


if [ "$FORM_set_threshold" != "" ] ; then
    logger "threshold: "$FORM_set_threshold
    uci set flexa_app.AppParam.threshold=$FORM_set_threshold
    add_to_control_json threshold $FORM_set_threshold
fi

%>


