<% 
. /usr/local/lib/cgi/generic.sh 
. /usr/local/lib/cgi/config.sh

# Extract application name from manifest
APP_NAME=`python /usr/local/www/current/scripts/getManifestProperty.py name`

# Set the parent page title according manifest
function getAppName()   {
	if [ ! -z "${APP_NAME}" ]; then echo -n "${APP_NAME}"; else echo -n "BarixDevice"; fi
}

DEV_NAME=$(getAppName)
TIME_TAG=$(date +%Y%m%d%H%M%S)
MAC_ADDR=$(cat /sys/class/net/eth0/address | tr "[a-z]" "[A-Z]" | tr ":" "-")

CONFIG_FILE=/mnt/data/package/config.json

if [ -f "${CONFIG_FILE}" ]; then
  echo "Content-Disposition: attachment; filename=${DEV_NAME}_${MAC_ADDR}_${TIME_TAG}_config.json"
  print_http_hdr text/plain
  jq .AppParam ${CONFIG_FILE}
else
   %>
     <html lang="en_US">
       <head>
          <script> function triggerFileNotFoundNotification() { window.location.href = 'Flexa_home.cgi?notification=Configuration+file+not+found.&level=warning';} </script>
       </head>
       <body onload="triggerFileNotFoundNotification()">
       </body>
     </html>
  <%
fi
%>