
from typing import *
import subprocess
import json
import logging

def findLicense(name: str) -> Tuple[bool,str] :
    try:
        ph = subprocess.Popen( [ "qiba-spi-get-info"] , stdout=subprocess.PIPE )
        out , _ = ph.communicate()
        factoryInfo = json.loads(out.decode("utf-8"))
        licenses    = factoryInfo["SW_LICENSES"]

        for license in licenses:
            if license["Image_Name"]==name:
                return True, license["Image_Features"]
        
    except Exception as ex:
        logger  = logging.getLogger("barix")
        logger.error("Error fetching factory info or licenses:", ex)

    return False,None

