import alsaaudio

class SourceState:
    def __init__(self):
        pass
    
    STOPPED = 1 # AudioSource is stopped. Not monitoring, not playing...
    MONITORING = 2 # AudioSource is monitoring its source but doesn't play
    PLAYING = 3 # AudioSource is playing its source (and monitoring too)


class AudioSource(object):
    def __init__(self,sourceId,sourceName,sourceVolume,sourceConfig,audioDev):
        self.id         = sourceId
        self.name       = sourceName
        self.volume     = sourceVolume
        self.params     = sourceConfig
        self.audioDev   = audioDev
        conf = self.audioDev.split(':')
        self.audioChannel = conf[1]
        if sourceVolume is not None:
            self.setVolume()
        self.observers  = list() # hype: List[Callable(int,string,bool)]
        pass


    """
    Start playing audio.
    After this call, AudioSource should transition into SourceState.PLAYING
    """
    def playAudio(self):
        raise NotImplementedError("AudioSource cannot be directly instantiated!")

    """
    Stop playing and stop monitoring.
    After this call:
     * AudioSource *must* stop playing.
     * when getState is called, the isAlive flags is ignored, so monitoring
       can be stopped as well
    """
    def stopAudio(self):
        raise NotImplementedError("AudioSource cannot be directly instantiated!")

    """
    Start monitoring the audio source, BUT don't play it
    After this call the state should become AudioSource.MONITORING
    Although we are monitoring the source, playback is *not allowed*
    """
    def checkAudio(self):
        raise NotImplementedError("AudioSource cannot be directly instantiated!")


    """
    Get current state of the audio source
    Return value:
        Returns a tuple containing:
          ( state , isAlive )
          state (SourceState) - the current state of the source. Note that
            it may take a while for state to reflect the calls to play(), stop()
            and monitor()
          isAlive (bool) - if state is PLAYING or MONITORING, this is a reliable
          indication whether audio is playing out or not.
    """
    def getState(self):
        raise NotImplementedError("AudioSource cannot be directly instantiated!")

    def setVolume(self, volume=None):
        if volume == None:
            volume = self.volume
        m = alsaaudio.Mixer(self.audioChannel)
        m.setvolume(int(volume))
    
    def reportStatus(self):
        raise NotImplementedError("AudioSource cannot be directly instantiated!")

    def addSourceStateObserver(self,observer):
        self.observers.append(observer)


    def removeSourceStateObserver(self,observer):
        self.observers.remove(observer)


    def sendSourceStateUpdate(self,state,alive):
        for observer in self.observers:
            observer(self.id,state,alive)

    def getParameter(self,name:str) -> str:
        if name not in self.params:
            return None
        return self.params[name]

    def getAudioDev(self):
        return self.audioDev
    
    def getName(self) -> str:
        return self.name
