#!/bin/sh

LED1_GREEN=/sys/class/leds/barix\:led1\:green
LED1_RED=/sys/class/leds/barix\:led1\:red
LED2_GREEN=/sys/class/leds/barix\:led2\:green
LED2_RED=/sys/class/leds/barix\:led2\:red

led1_set_green() {
  if [ -d $LED1_RED ]; then
    echo "none" > $LED1_RED/trigger
    echo "0" > $LED1_RED/brightness
  fi
  if [ -d $LED1_GREEN ]; then
    echo "none" > $LED1_GREEN/trigger
    echo "255" > $LED1_GREEN/brightness
  fi
}

led1_set_red() {
  if [ -d $LED1_RED ]; then
    echo "none" > $LED1_RED/trigger
    echo "255" > $LED1_RED/brightness
  fi
  if [ -d $LED1_GREEN ]; then
    echo "none" > $LED1_GREEN/trigger
    echo "0" > $LED1_GREEN/brightness
  fi
}

led1_set_yel() {
  if [ -d $LED1_RED ]; then
    echo "none" > $LED1_RED/trigger
    echo "255" > $LED1_RED/brightness
  fi
  if [ -d $LED1_GREEN ]; then
    echo "none" > $LED1_GREEN/trigger
    echo "255" > $LED1_GREEN/brightness
  fi
}

led1_set_blink() {
    local color=$1
    local timeOn=$2
    local timeOff=$3
    if [ "$color" == "red" ] && [ -d $LED1_RED ]; then
        led1_set_red
        echo "timer" > $LED1_RED/trigger
        echo "$timeOn" > $LED1_RED/delay_on
        echo "$timeOff" > $LED1_RED/delay_off
    elif [ "$color" == "green" ] && [ -d $LED1_GREEN ]; then
        led1_set_green
        echo "timer" > $LED1_GREEN/trigger
        echo "$timeOn" > $LED1_GREEN/delay_on
        echo "$timeOff" > $LED1_GREEN/delay_off
    elif [ "$color" == "yellow" ] && [ -d $LED1_GREEN ] && [ -d $LED1_RED]; then
        led1_set_yel
        echo "timer" > $LED1_GREEN/trigger
        echo "timer" > $LED1_RED/trigger
        echo "$timeOn" > $LED1_GREEN/delay_on
        echo "$timeOff" > $LED1_GREEN/delay_off
        echo "$timeOn" > $LED1_RED/delay_on
        echo "$timeOff" > $LED1_RED/delay_off
    else
        echo "Unknown color!"
    fi
}

led1_set_yel_blink() {
  if [ -d $LED1_GREEN ]; then
    echo "timer" > $LED1_GREEN/trigger
    echo "100" > $LED1_GREEN/delay_on
    echo "100" > $LED1_GREEN/delay_off
  fi
  if [ -d $LED1_RED ]; then
    echo "timer" > $LED1_RED/trigger
    echo "100" > $LED1_RED/delay_off
    echo "100" > $LED1_RED/delay_on
  fi
}

led2_set_green() {
  if [ -d $LED2_RED ]; then
    echo "none" > $LED2_RED/trigger
    echo "0" > $LED2_RED/brightness
  fi
  if [ -d $LED2_GREEN ]; then
    echo "none" > $LED2_GREEN/trigger
    echo "255" > $LED2_GREEN/brightness
  fi
}

led2_set_red() {
  if [ -d $LED2_RED ]; then
    echo "none" > $LED2_RED/trigger
    echo "255" > $LED2_RED/brightness
  fi
  if [ -d $LED2_GREEN ]; then
    echo "none" > $LED2_GREEN/trigger
    echo "0" > $LED2_GREEN/brightness
  fi
}

led2_set_red_blink() {
  if [ -d $LED2_RED ]; then
    echo "timer" > $LED2_RED/trigger
    echo "255" > $LED2_RED/brightness
  fi
  if [ -d $LED2_GREEN ]; then
    echo "none" > $LED2_GREEN/trigger
    echo "0" > $LED2_GREEN/brightness
  fi
}

led2_set_green_blink() {
  if [ -d $LED2_GREEN ]; then
    echo "timer" > $LED2_GREEN/trigger
    echo "255" > $LED2_GREEN/brightness
  fi
  if [ -d $LED2_RED ]; then
    echo "none" > $LED2_RED/trigger
    echo "0" > $LED2_RED/brightness
  fi
}

led2_set_yel_blink() {
  if [ -d $LED2_GREEN ]; then
    echo "timer" > $LED2_GREEN/trigger
    echo "100" > $LED2_GREEN/delay_on
    echo "100" > $LED2_GREEN/delay_off
  fi
  if [ -d $LED2_RED ]; then
    echo "timer" > $LED2_RED/trigger
    echo "100" > $LED2_RED/delay_off
    echo "100" > $LED2_RED/delay_on
  fi
}

led2_set_blink() {
    local color=$1
    local timeOn=$2
    local timeOff=$3
    if [ "$color" == "red" ] && [ -d $LED2_RED ]; then
        led2_set_red
        echo "timer" > $LED2_RED/trigger
        echo "$timeOn" > $LED2_RED/delay_on
        echo "$timeOff" > $LED2_RED/delay_off
    elif [ "$color" == "green" ] && [ -d $LED2_GREEN ]; then
        led2_set_green
        echo "timer" > $LED2_GREEN/trigger
        echo "$timeOn" > $LED2_GREEN/delay_on
        echo "$timeOff" > $LED2_GREEN/delay_off
    elif [ "$color" == "yellow" ] && [ -d $LED2_GREEN ] && [ -d $LED2_RED]; then
        led2_set_yel
        echo "timer" > $LED2_GREEN/trigger
        echo "timer" > $LED2_RED/trigger
        echo "$timeOn" > $LED2_GREEN/delay_on
        echo "$timeOff" > $LED2_GREEN/delay_off
        echo "$timeOn" > $LED2_RED/delay_on
        echo "$timeOff" > $LED2_RED/delay_off
    else
        echo "Unknown color!"
    fi
}
