#!/bin/bash

export SDF_FILE=sdf.json
export SDF_CONFIG=config.json
export SDF_PORT=6080
export SDF_LOG_PATH="./"


# Check if the number of parameters is exactly 1
if [ "$#" -ne 1 ]; then
    echo "Error: Must define a parameter with SDF config."
    exit 1
fi

# Check if the parameter is a file
if [ ! -f "$1" ]; then
    echo "Error: The parameter must be the name of an existing SDF config file."
    exit 1
fi

rm sdf.json
ln -s "${1}" sdf.json


POSITIONAL_ARGS=()

while [[ $# -gt 0 ]]; do
  case $1 in
    -f|--file)
      export SDF_FILE="$2"
      shift # past argument
      shift # past value
      ;;
    -c|--config)
      export SDF_CONFIG="$2"
      shift # past argument
      shift # past value
      ;;
    -p|--port)
      export SDF_PORT="$2"
      shift # past argument
      shift # past value
      ;;
    -*|--*)
      echo "Unknown option $1"
      exit 1
      ;;
    *)
      POSITIONAL_ARGS+=("$1") # save positional arg
      shift # past argument
      ;;
  esac
done


## Use Flask
python3 server.py

## Use gunicorn
# gunicorn -b 0.0.0.0:${SDF_PORT} -w 1 server:app
