import logging
import os
from logger import config_logger
from routes.web_API import web_bp
from flask import Flask, send_from_directory, Response
from constants import LOG_NAME
from sdf_file import SdfFile

app = Flask(__name__, static_url_path='', static_folder='static', template_folder='static')

try:
    app.config["sdf"] = os.environ.get('SDF_FILE')
    app.config["values"] = os.environ.get('SDF_CONFIG')
    app.config["port"] = os.environ.get('SDF_PORT')
    app.config["log_path"] = os.environ.get('SDF_LOG_PATH')
except Exception as e:
    print(f"Exception: {e}")


# Register routes
def register_routes():
    # web routes
    app.register_blueprint(web_bp, url_prefix='/web/api/v1')

    # static routes
    @app.route('/')
    def frontend_pages0(**kwargs):
        return send_from_directory(app.static_folder, 'index.html')

    @app.route('/app-settings/<path:path>')
    def static_file(path):
        logger.debug(path)
        return app.send_static_file(path)

    @app.route('/app-settings')
    def debug_endpoint(**kwargs):
        logger.debug("Received")
        return send_from_directory(app.static_folder, 'index.html')


# Configure logger
log_file_path = os.path.join(app.config["log_path"], LOG_NAME + ".log")
config_logger(LOG_NAME, log_file_path, 2 * 1024 * 1024, 2, True)
logger = logging.getLogger(LOG_NAME)
logger.info("Starting local config webui server backend...")

# Generate schema validator
sdf = None
try:
    logger.info(f"SDF file: '{app.config['sdf']}', Config file: '{app.config['values']}'")
    sdf = SdfFile(filepath=app.config["sdf"])
except Exception as e:
    logger.error("Unexpected error while loading SDF: {}".format(e))
finally:
    app.config["sdf"] = sdf

register_routes()

if __name__ == "__main__":
    app.run(host='127.0.0.1', port=app.config["port"])
