from typing import List, Union, Dict

SdfVarType = Union["number", "string", "boolean", "List[string]", "List[number]"]
SdfWidgetType = Union["number", "text", "boolean", "selection"]
SdfConfigType = Union["section", "param", "division"]

sdfConfigTypes: List[SdfConfigType] = ["section", "param", "division"]
sdfVarTypes = ["number", "string", "boolean", "List[string]", "List[number]"]



class SdfFormData:
    def __init__(self, label: str, key: str):
        self.label = label
        self.key = key

class SdfSectionData(SdfFormData):
    def __init__(self, label: str, key: str, content: List["SdfConfig"], icon: str = None):
        super().__init__(label, key)
        self.content = content
        self.icon = icon

class SdfDivisionData:
    def __init__(self, label: str, icon: str = None):
        self.label = label
        self.icon = icon

class SdfConditional:
    def __init__(self, config: List["SdfConfig"], when_value_is=None, when_value_is_not=None,
                 when_value_is_gt=None, when_value_is_lt=None, when_value_is_ge=None, when_value_is_le=None):
        self.when_value_is = when_value_is
        self.when_value_is_not = when_value_is_not
        self.when_value_is_gt = when_value_is_gt
        self.when_value_is_lt = when_value_is_lt
        self.when_value_is_ge = when_value_is_ge
        self.when_value_is_le = when_value_is_le
        self.config = config

class SdfTypeProperties:
    def __init__(self, widget=None, units=None, min=None, max=None, step=None, regexp=None,
                 options: Dict[str,str] = None, disabled=None):
        self.widget = widget
        self.units = units
        self.min = min
        self.max = max
        self.step = step
        self.regexp = regexp
        self.options = options
        self.disabled = disabled

class SdfParamData(SdfFormData):
    def __init__(self, label: str, key: str, var_type: SdfVarType, type: SdfWidgetType,
                 type_properties: SdfTypeProperties, required: bool = None, default_value=None,
                 conditional=None, sdf_help: bool = None, scope: str = None, tooltip=None, placeholder=None):
        super().__init__(label, key)
        self.var_type = var_type
        self.type = type
        self.type_properties = type_properties
        self.required = required
        self.default_value = default_value
        self.conditional = conditional
        self.help = sdf_help
        self.scope = scope
        self.tooltip = tooltip
        self.placeholder = placeholder

SdfData = Union[SdfSectionData, SdfParamData]

class SdfConfigSection:
    def __init__(self, c_data: SdfSectionData):
        self.c_type = "section"
        self.c_data = c_data

class SdfConfigParam:
    def __init__(self, c_data: SdfParamData):
        self.c_type = "param"
        self.c_data = c_data

class SdfConfigDivision:
    def __init__(self, c_data: SdfDivisionData):
        self.c_type = "division"
        self.c_data = c_data

SdfConfig = Union[SdfConfigSection, SdfConfigParam, SdfConfigDivision]

class SdfScope:
    def __init__(self, name: str, max_occurrences: int = None):
        self.name = name
        self.max_occurrences = max_occurrences

class Sdf:
    def __init__(self, config: List[SdfConfig], scopes: List[SdfScope] = None):
        self.config = config
        self.scopes = scopes