import json
import logging
import os
from constants import LOG_NAME
from sdf_types import Sdf

logger = logging.getLogger(LOG_NAME)


class SdfFile:

    def __init__(self, filepath):
        self.valid = True
        self.filepath = filepath
        self.content = self.load_sdf()

    def load_sdf(self):
        # check if SDF file exists
        if not os.path.isfile(self.filepath):
            logger.error("SDF JSON file does not exist!")
            self.valid = False
            return "SDF config not found"

        # read sdf file contents
        try:
            with open(self.filepath, 'r') as f:
                sdf_json = json.load(f)
        except Exception as e:
            logger.error("Error reading SDF JSON file: {}".format(e))
            self.valid = False
            return None

        return sdf_json
