from functools import wraps
from flask import request
from logger import get_backend_log
logger = get_backend_log()


def endpoint_log(f):
    @wraps(f)
    def wrap(*args, **kwargs):
        logger.info(f"[{request.method}] {request.full_path}")
        return f(*args, **kwargs)
    return wrap
