import logging
from logging.handlers import RotatingFileHandler
from constants import LOG_NAME

"""
Init logger
"""


def config_logger(name, log_file_path, log_max_size, log_backup_count, debug_mode=False):
    log = logging.getLogger(name)
    if debug_mode:
        log.setLevel(logging.DEBUG)
    else:
        log.setLevel(logging.INFO)
    rot_handler = RotatingFileHandler(log_file_path, maxBytes=log_max_size, backupCount=log_backup_count)
    format1 = logging.Formatter('%(asctime)s  %(levelname)s  %(filename)s:%(lineno)s  %(message)s')
    rot_handler.setFormatter(format1)
    log.addHandler(rot_handler)


def get_backend_log():
    return logging.getLogger(LOG_NAME)

