#!/usr/bin/python3

with open('/barix/info/licenses-report.csv', 'r') as file:
    lines = file.readlines()

filtered_lines = []
for line in lines:
    # Discard lines that do not start with "python-"
    line = line.strip().replace('"', '')  # Remove extra double quotes
    if line.startswith('python3-'):
        fields = line.strip().split(',')
        # Check if the third field is not "CLOSED"
        if len(fields) >= 3 and fields[2] != '"CLOSED"':
            # Format and append the desired output
            prefix, version, license_type = fields[0], fields[1], fields[2]
            formatted_line = f"{prefix.split('-')[1]}=={version}"
            filtered_lines.append(formatted_line)

# Output the filtered lines
for line in filtered_lines:
    print(line)
