#!/usr/bin/python3
#
#   Test Flexa firmware version looking to manifest.json
#
#   Will set a exist status:
#       0 - if manifest match with firmware version.
#       1 - if manifest do not match with firmware version or firmware version file do not exists.

import sys
import json

# Test python version
if sys.version_info[0] < 3:
    print('Must be using Python 3')
    sys.exit(-1)

# Complete paths are required to work with web-ui
firmware_version_file_location = '/barix/info/VERSION'
manifest_file_location = '/mnt/data/package/manifest.json'

param_show_manifest = False
param_verbosely = False
param_help = False
for arg in sys.argv:
    if arg == sys.argv[0]:
        continue
    if arg == '-s':
        param_show_manifest = True
        break
    if arg == '-v':
        param_verbosely = True
        break
    param_help = True


def versionCompare(version1, version2):

    parts1 = [int(x) for x in version1.split('.')]
    parts2 = [int(x) for x in version2.split('.')]

    # fill up the shorter version with zeros ...
    lendiff = len(parts1) - len(parts2)
    if lendiff > 0:
        parts2.extend([0] * lendiff)
    elif lendiff < 0:
        parts1.extend([0] * (-lendiff))

    for i, p in enumerate(parts1):
        # Compare "p" and "parts2[i]" as python 3 flavor
        ret = (p > parts2[i]) - (p < parts2[i])
        if ret: return ret
    return 0


firmware_version = "0"
try:
    with open(firmware_version_file_location, 'r') as firmware_version_file:
        firmware_version = firmware_version_file.read().split('\n')[0] # Read only 1st line
except:
    sys.exit(2)

valid = False
supported = []
matches = []

### Cavilha número 1
### TODO: REMOVE ME PLEASE!
firmware_version = "1.5.0"

try:
    with open(manifest_file_location) as json_file:

        data = json.load(json_file)
        for conditionElement in data['firmware_versions']:
            if 'exactly' in conditionElement:
                supported.append('='+conditionElement['exactly'])
                if versionCompare(conditionElement['exactly'], firmware_version) == 0:
                    valid = valid or True
                    matches.append(supported.__len__()-1)
                    continue
            if 'from' in conditionElement:
                if 'to' in conditionElement:
                    if versionCompare(conditionElement['from'], firmware_version) < 1:
                        supported.append('[' + conditionElement['from'] + ', ' + conditionElement['to'] + '[')
                        if versionCompare(conditionElement['to'], firmware_version) > 0:
                            valid = valid or True
                            matches.append(supported.__len__() - 1)
                            continue
                else:
                    supported.append('>=' + conditionElement['from'])
                    if versionCompare(conditionElement['from'], firmware_version) < 1:
                        valid = valid or True
                        matches.append(supported.__len__() - 1)
                        continue
            if 'to' in conditionElement:
                if 'from' in conditionElement:
                    if versionCompare(conditionElement['to'], firmware_version) > 0:
                        supported.append('[' + conditionElement['from'] + ', ' + conditionElement['to'] + '[')
                        if versionCompare(conditionElement['from'], firmware_version) < 1:
                            valid = valid or True
                            matches.append(supported.__len__() - 1)
                            continue
                else:
                    supported.append('<' + conditionElement['to'])
                    if versionCompare(conditionElement['to'], firmware_version) > 0:
                        valid = valid or True
                        matches.append(supported.__len__() - 1)
                        continue
except:
    sys.exit(3)


t_bold = "\033[1m"
t_normal = "\033[00m"
t_green = "\033[1;32m"
t_red = "\033[1;31m"

def print_barix_header():
    print("\n  \033[1;30;47m BARIX {}  Flexa firmware version test tool.\n".format(t_normal))

def show_help():
    print_barix_header()
    print("Validates the firmware version from the manifest file. Without options, the exit status will be \"0\" if the manifest conforms to the firmware version.")
    print("\n\tUsage:\t{}{} [-h|-s|-v]{}\n".format(t_bold, sys.argv[0], t_normal))
    print("\t{}-h{}\tShow this help.".format(t_bold, t_normal))
    print("\t{}-s{}\tAlso show firmware versions declared in manifest file.".format(t_bold, t_normal))
    print("\t{}-v{}\tVerbosely info (files, versions)".format(t_bold, t_normal))
    print('')

def show_verbosely():

    for match in matches:
        supported[match]=t_green+supported[match]+t_normal

    print_barix_header()
    print("{}Firmware{}: {} \tversion {}{}{}".format(t_bold, t_normal, firmware_version_file_location, t_bold, firmware_version, t_normal))
    print("{}Manifest{}: {} \tversions {}".format(t_bold, t_normal, manifest_file_location, ('; '.join(supported))))
    if valid:
        print("\nFlexa application {}is compatible{} with firmware".format(t_green, t_normal))
    else:
        print("\nFlexa application {}is not compatible{} with firmware".format(t_red, t_normal))
    print('')

if param_show_manifest:
    print("{}".format('; '.join(supported)))
if param_help:
    show_help()
if param_verbosely:
    show_verbosely()

if valid:
    sys.exit(0)
else:
    sys.exit(1)
